/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api;

import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.SonarProduct;
import org.sonar.api.SonarQubeSide;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.internal.google.common.base.Preconditions;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.Version;
import org.sonarsource.api.sonarlint.SonarLintSide;

@ScannerSide
@ServerSide
@ComputeEngineSide
@SonarLintSide
@Immutable
public class SonarRuntime {
    public static final Version V5_5 = Version.create(5, 5);
    public static final Version V5_6 = Version.create(5, 6);
    public static final Version V6_0 = Version.create(6, 0);
    private final Version version;
    private final SonarProduct product;
    private final SonarQubeSide sonarQubeSide;

    public SonarRuntime(Version version, SonarProduct product, @Nullable SonarQubeSide sonarQubeSide) {
        Objects.requireNonNull(version);
        Objects.requireNonNull(product);
        Preconditions.checkArgument(product == SonarProduct.SONARQUBE == (sonarQubeSide != null), "sonarQubeSide should be provided only for SonarQube product");
        this.version = version;
        this.product = product;
        this.sonarQubeSide = sonarQubeSide;
    }

    public Version getApiVersion() {
        return this.version;
    }

    public boolean isGreaterThanOrEqual(Version than) {
        return this.version.isGreaterThanOrEqual(than);
    }

    public SonarProduct getProduct() {
        return this.product;
    }

    public SonarQubeSide getSonarQubeSide() {
        if (this.sonarQubeSide == null) {
            throw new UnsupportedOperationException("Can only be called in SonarQube");
        }
        return this.sonarQubeSide;
    }
}

