/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.internal;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import org.sonar.api.SonarProduct;
import org.sonar.api.SonarQubeSide;
import org.sonar.api.SonarQubeVersion;
import org.sonar.api.internal.google.common.io.Resources;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.Version;

public class SonarRuntimeFactory {
    private static final String FILE_PATH = "/sq-version.txt";

    private SonarRuntimeFactory() {
    }

    public static SonarQubeVersion create(System2 system, SonarProduct product, @Nullable SonarQubeSide sonarQubeSide) {
        try {
            URL url = system.getResource(FILE_PATH);
            String versionInFile = Resources.toString(url, StandardCharsets.UTF_8);
            return new SonarQubeVersion(Version.parse(versionInFile), product, sonarQubeSide);
        }
        catch (IOException e) {
            throw new IllegalStateException("Can not load /sq-version.txt from classpath", e);
        }
    }
}

