/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.sonar.api.internal.apachecommons.io.FileUtils;
import org.sonar.api.internal.apachecommons.io.IOUtils;

public final class ZipUtils {
    private static final String ERROR_CREATING_DIRECTORY = "Error creating directory: ";

    private ZipUtils() {
    }

    public static File unzip(File zip, File toDir) throws IOException {
        ZipUtils.unzip(zip, toDir, (ZipEntryFilter)TrueZipEntryFilter.INSTANCE);
        return toDir;
    }

    public static File unzip(InputStream zip, File toDir) throws IOException {
        ZipUtils.unzip(zip, toDir, (ZipEntryFilter)TrueZipEntryFilter.INSTANCE);
        return toDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File unzip(InputStream stream, File toDir, ZipEntryFilter filter) throws IOException {
        if (!toDir.exists()) {
            FileUtils.forceMkdir(toDir);
        }
        try (ZipInputStream zipStream = new ZipInputStream(stream);){
            ZipEntry entry;
            while ((entry = zipStream.getNextEntry()) != null) {
                if (!filter.accept(entry)) continue;
                File to = new File(toDir, entry.getName());
                if (entry.isDirectory()) {
                    ZipUtils.throwExceptionIfDirectoryIsNotCreatable(to);
                    continue;
                }
                File parent = to.getParentFile();
                ZipUtils.throwExceptionIfDirectoryIsNotCreatable(parent);
                ZipUtils.copy(zipStream, to);
            }
            File file = toDir;
            return file;
        }
    }

    private static void throwExceptionIfDirectoryIsNotCreatable(File to) throws IOException {
        if (!to.exists() && !to.mkdirs()) {
            throw new IOException(ERROR_CREATING_DIRECTORY + to);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File unzip(File zip, File toDir, ZipEntryFilter filter) throws IOException {
        if (!toDir.exists()) {
            FileUtils.forceMkdir(toDir);
        }
        try (ZipFile zipFile = new ZipFile(zip);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!filter.accept(entry)) continue;
                File to = new File(toDir, entry.getName());
                if (entry.isDirectory()) {
                    ZipUtils.throwExceptionIfDirectoryIsNotCreatable(to);
                    continue;
                }
                File parent = to.getParentFile();
                ZipUtils.throwExceptionIfDirectoryIsNotCreatable(parent);
                ZipUtils.copy(zipFile, entry, to);
            }
            File file = toDir;
            return file;
        }
    }

    private static void copy(ZipInputStream zipStream, File to) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(to);
            IOUtils.copy((InputStream)zipStream, (OutputStream)fos);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly(fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(ZipFile zipFile, ZipEntry entry, File to) throws IOException {
        FileOutputStream fos = new FileOutputStream(to);
        InputStream input = null;
        try {
            input = zipFile.getInputStream(entry);
            IOUtils.copy(input, (OutputStream)fos);
        }
        finally {
            IOUtils.closeQuietly(input);
            IOUtils.closeQuietly(fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipDir(File dir, File zip) throws IOException {
        FileOutputStream out = null;
        ZipOutputStream zout = null;
        try {
            out = FileUtils.openOutputStream(zip);
            zout = new ZipOutputStream(out);
            ZipUtils.doZipDir(dir, zout);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(zout);
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly(zout);
        IOUtils.closeQuietly(out);
    }

    private static void doZip(String entryName, InputStream in, ZipOutputStream out) throws IOException {
        ZipEntry entry = new ZipEntry(entryName);
        out.putNextEntry(entry);
        IOUtils.copy(in, (OutputStream)out);
        out.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void doZip(String entryName, File file, ZipOutputStream out) throws IOException {
        if (file.isDirectory()) {
            entryName = entryName + "/";
            ZipEntry entry = new ZipEntry(entryName);
            out.putNextEntry(entry);
            out.closeEntry();
            File[] files = file.listFiles();
            if (files == null) {
                throw new IllegalStateException("Fail to list files of directory " + file.getAbsolutePath());
            }
            File[] fileArray = files;
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                ZipUtils.doZip(entryName + f.getName(), f, out);
                ++n2;
            }
            return;
        }
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            ZipUtils.doZip(entryName, in, out);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly(in);
    }

    private static void doZipDir(File dir, ZipOutputStream out) throws IOException {
        File[] children = dir.listFiles();
        if (children == null) {
            throw new IllegalStateException("Fail to list files of directory " + dir.getAbsolutePath());
        }
        for (File child : children) {
            ZipUtils.doZip(child.getName(), child, out);
        }
    }

    @FunctionalInterface
    public static interface ZipEntryFilter {
        public boolean accept(ZipEntry var1);
    }

    private static enum TrueZipEntryFilter implements ZipEntryFilter
    {
        INSTANCE;


        @Override
        public boolean accept(ZipEntry entry) {
            return true;
        }
    }
}

