/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.measures;

import java.io.Serializable;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.internal.apachecommons.lang.builder.ReflectionToStringBuilder;
import org.sonar.api.internal.apachecommons.lang.math.NumberUtils;
import org.sonar.api.internal.google.common.annotations.Beta;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.PersistenceMode;

@Deprecated
public class Measure<G extends Serializable>
implements Serializable {
    private static final String INDEX_SHOULD_BE_IN_RANGE_FROM_1_TO_5 = "Index should be in range from 1 to 5";
    protected static final int MAX_TEXT_SIZE = 96;
    @Deprecated
    public static final int DEFAULT_PRECISION = 1;
    protected String metricKey;
    protected Metric<G> metric;
    protected Double value;
    protected String data;
    protected String description;
    protected Metric.Level alertStatus;
    protected String alertText;
    protected Date date;
    protected Double variation1;
    protected Double variation2;
    protected Double variation3;
    protected Double variation4;
    protected Double variation5;
    protected String url;
    protected Integer personId;
    protected PersistenceMode persistenceMode = PersistenceMode.FULL;

    public Measure(String metricKey) {
        this.metricKey = metricKey;
    }

    public Measure(Metric metric) {
        this.metric = metric;
        this.metricKey = metric.getKey();
    }

    public Measure(Metric metric, Double value) {
        this.metric = metric;
        this.metricKey = metric.getKey();
        this.setValue(value);
    }

    public Measure(Metric metric, Double value, int precision) {
        this.metric = metric;
        this.metricKey = metric.getKey();
        this.setValue(value, precision);
    }

    public Measure(Metric metric, Double value, String data) {
        this.metric = metric;
        this.metricKey = metric.getKey();
        this.setValue(value);
        this.setData(data);
    }

    public Measure(Metric metric, String data) {
        this.metric = metric;
        this.metricKey = metric.getKey();
        this.setData(data);
    }

    public Measure(Metric metric, @Nullable Metric.Level level) {
        this.metric = metric;
        this.metricKey = metric.getKey();
        if (level != null) {
            this.data = level.toString();
        }
    }

    public Measure() {
    }

    public PersistenceMode getPersistenceMode() {
        return this.persistenceMode;
    }

    public Measure<G> setPersistenceMode(@Nullable PersistenceMode mode) {
        this.persistenceMode = mode == null ? PersistenceMode.FULL : mode;
        return this;
    }

    public Metric<G> getMetric() {
        return this.metric;
    }

    public String getMetricKey() {
        return this.metricKey;
    }

    public Measure<G> setMetric(Metric<G> metric) {
        this.metric = metric;
        this.metricKey = metric.getKey();
        return this;
    }

    public Metric.Level getDataAsLevel() {
        if (this.data != null) {
            return Metric.Level.valueOf(this.data);
        }
        return null;
    }

    public boolean hasData() {
        return this.data != null;
    }

    public Date getDate() {
        return this.date;
    }

    public Measure<G> setDate(Date date) {
        this.date = date;
        return this;
    }

    @CheckForNull
    public Double getValue() {
        return this.value;
    }

    public G value() {
        if (this.value == null) {
            return null;
        }
        switch (this.getMetric().getType()) {
            case BOOL: {
                return (G)Boolean.valueOf(Double.doubleToRawLongBits(this.value) != 0L);
            }
            case INT: 
            case MILLISEC: 
            case RATING: {
                return (G)Integer.valueOf(this.value.intValue());
            }
            case FLOAT: 
            case PERCENT: 
            case STRING: 
            case LEVEL: 
            case DATA: 
            case DISTRIB: {
                return (G)this.data;
            }
            case WORK_DUR: {
                return (G)Long.valueOf(this.value.longValue());
            }
        }
        if (this.getMetric().isNumericType() || this.getMetric().isDataType()) {
            return (G)this.value;
        }
        throw new UnsupportedOperationException("Unsupported type :" + (Object)((Object)this.getMetric().getType()));
    }

    public Integer getIntValue() {
        if (this.value == null) {
            return null;
        }
        return this.value.intValue();
    }

    public Measure<G> setValue(@Nullable Double v) {
        return this.setValue(v, 1);
    }

    public Measure<G> setRawValue(@Nullable Double v) {
        this.value = v;
        return this;
    }

    public Measure<G> setIntValue(@Nullable Integer i) {
        this.value = i == null ? null : Double.valueOf(i.intValue());
        return this;
    }

    @Deprecated
    public Measure<G> setValue(@Nullable Double v, int decimalScale) {
        if (v != null) {
            if (Double.isNaN(v)) {
                throw new IllegalArgumentException("Measure value can not be NaN");
            }
            this.value = v;
        } else {
            this.value = null;
        }
        return this;
    }

    @CheckForNull
    public String getData() {
        return this.data;
    }

    public Measure<G> setData(String s) {
        this.data = s;
        return this;
    }

    public Measure<G> setData(@Nullable Metric.Level level) {
        this.data = level == null ? null : level.toString();
        return this;
    }

    public Measure<G> unsetData() {
        this.data = null;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Measure<G> setDescription(String description) {
        this.description = description;
        return this;
    }

    public Metric.Level getAlertStatus() {
        return this.alertStatus;
    }

    public Measure<G> setAlertStatus(@Nullable Metric.Level status) {
        this.alertStatus = status;
        return this;
    }

    public String getAlertText() {
        return this.alertText;
    }

    public Measure<G> setAlertText(@Nullable String alertText) {
        this.alertText = alertText;
        return this;
    }

    @Deprecated
    @CheckForNull
    public Integer getTendency() {
        return null;
    }

    @Deprecated
    public Measure<G> setTendency(@Nullable Integer tendency) {
        return this;
    }

    public Double getVariation1() {
        return this.variation1;
    }

    public Measure<G> setVariation1(@Nullable Double d) {
        this.variation1 = d;
        return this;
    }

    public Double getVariation2() {
        return this.variation2;
    }

    public Measure<G> setVariation2(@Nullable Double d) {
        this.variation2 = d;
        return this;
    }

    public Double getVariation3() {
        return this.variation3;
    }

    public Measure<G> setVariation3(@Nullable Double d) {
        this.variation3 = d;
        return this;
    }

    public Double getVariation4() {
        return this.variation4;
    }

    public Measure<G> setVariation4(@Nullable Double d) {
        this.variation4 = d;
        return this;
    }

    public Double getVariation5() {
        return this.variation5;
    }

    public Measure<G> setVariation5(@Nullable Double d) {
        this.variation5 = d;
        return this;
    }

    public Double getVariation(int index) {
        switch (index) {
            case 1: {
                return this.variation1;
            }
            case 2: {
                return this.variation2;
            }
            case 3: {
                return this.variation3;
            }
            case 4: {
                return this.variation4;
            }
            case 5: {
                return this.variation5;
            }
        }
        throw new IndexOutOfBoundsException(INDEX_SHOULD_BE_IN_RANGE_FROM_1_TO_5);
    }

    public Measure<G> setVariation(int index, Double d) {
        switch (index) {
            case 1: {
                this.variation1 = d;
                break;
            }
            case 2: {
                this.variation2 = d;
                break;
            }
            case 3: {
                this.variation3 = d;
                break;
            }
            case 4: {
                this.variation4 = d;
                break;
            }
            case 5: {
                this.variation5 = d;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(INDEX_SHOULD_BE_IN_RANGE_FROM_1_TO_5);
            }
        }
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public Measure<G> setUrl(String url) {
        this.url = url;
        return this;
    }

    @CheckForNull
    @Beta
    public Integer getPersonId() {
        return this.personId;
    }

    @Beta
    public Measure<G> setPersonId(@Nullable Integer i) {
        this.personId = i;
        return this;
    }

    public boolean isBestValue() {
        Double bestValue = this.metric.getBestValue();
        return this.metric.isOptimizedBestValue() == Boolean.TRUE && bestValue != null && (this.value == null || NumberUtils.compare(bestValue, this.value) == 0) && Measure.allNull(new Object[]{this.alertStatus, this.description, this.url, this.data}) && Measure.isZeroVariation(this.variation1, this.variation2, this.variation3, this.variation4, this.variation5);
    }

    private static boolean isZeroVariation(Double ... variations) {
        for (Double variation : variations) {
            if (variation == null || NumberUtils.compare(variation, 0.0) == 0) continue;
            return false;
        }
        return true;
    }

    private static boolean allNull(Object ... values) {
        for (Object value : values) {
            if (null == value) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Measure measure = (Measure)o;
        if (this.metricKey != null ? !this.metricKey.equals(measure.metricKey) : measure.metricKey != null) {
            return false;
        }
        return !(this.personId == null ? measure.personId != null : !this.personId.equals(measure.personId));
    }

    public int hashCode() {
        int result = this.metricKey != null ? this.metricKey.hashCode() : 0;
        result = 31 * result + (this.personId != null ? this.personId.hashCode() : 0);
        return result;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
}

