/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.internal.google.common.base.Preconditions;
import org.sonar.api.internal.google.common.base.Strings;
import org.sonar.api.internal.google.common.collect.Maps;

@Immutable
public class ResourceType {
    private final String qualifier;
    private final String iconPath;
    private final boolean hasSourceCode;
    private Map<String, String> properties;

    private ResourceType(Builder builder) {
        this.qualifier = builder.qualifier;
        this.iconPath = builder.iconPath;
        this.hasSourceCode = builder.hasSourceCode;
        this.properties = Maps.newHashMap(builder.properties);
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public boolean hasSourceCode() {
        return this.hasSourceCode;
    }

    public boolean hasProperty(String key) {
        Preconditions.checkNotNull(key);
        return this.properties.containsKey(key);
    }

    public String getStringProperty(String key) {
        Preconditions.checkNotNull(key);
        return this.properties.get(key);
    }

    public boolean getBooleanProperty(String key) {
        Preconditions.checkNotNull(key);
        String value = this.properties.get(key);
        return value != null && Boolean.parseBoolean(value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceType that = (ResourceType)o;
        return this.qualifier.equals(that.qualifier);
    }

    public int hashCode() {
        return this.qualifier.hashCode();
    }

    public String toString() {
        return this.qualifier;
    }

    public static Builder builder(String qualifier) {
        Preconditions.checkNotNull(qualifier);
        Preconditions.checkArgument(qualifier.length() <= 10, "Qualifier is limited to 10 characters");
        return new Builder(qualifier);
    }

    public static class Builder {
        private String qualifier;
        private String iconPath;
        private boolean hasSourceCode = false;
        private final Map<String, String> properties = Maps.newHashMap();

        public Builder(String qualifier) {
            this.qualifier = qualifier;
        }

        public Builder setIconPath(@Nullable String iconPath) {
            this.iconPath = iconPath;
            return this;
        }

        @Deprecated
        public Builder availableForFilters() {
            return this;
        }

        public Builder hasSourceCode() {
            this.hasSourceCode = true;
            return this;
        }

        public Builder setProperty(String key, String value) {
            Preconditions.checkNotNull(key);
            Preconditions.checkNotNull(value);
            this.properties.put(key, value);
            return this;
        }

        public Builder setProperty(String key, boolean value) {
            return this.setProperty(key, String.valueOf(value));
        }

        public ResourceType build() {
            if (Strings.isNullOrEmpty(this.iconPath)) {
                this.iconPath = "/images/q/" + this.qualifier + ".png";
            }
            return new ResourceType(this);
        }
    }
}

