/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.detector.suffixtree;

import java.util.ArrayList;
import java.util.List;
import org.sonar.duplications.block.Block;
import org.sonar.duplications.detector.suffixtree.AbstractText;

public final class TextSet
extends AbstractText {
    private final int lengthOfOrigin;

    public static Builder builder() {
        return new Builder();
    }

    private TextSet(List<Object> symbols, int lengthOfOrigin) {
        super(symbols);
        this.lengthOfOrigin = lengthOfOrigin;
    }

    public boolean isInsideOrigin(int pos) {
        return pos < this.lengthOfOrigin;
    }

    @Override
    public Object symbolAt(int index) {
        Object obj = super.symbolAt(index);
        if (obj instanceof Block) {
            return ((Block)obj).getBlockHash();
        }
        return obj;
    }

    public Block getBlock(int index) {
        return (Block)super.symbolAt(index);
    }

    public static class Terminator {
        private final int stringNumber;

        public Terminator(int i) {
            this.stringNumber = i;
        }

        public boolean equals(Object obj) {
            return obj instanceof Terminator && ((Terminator)obj).stringNumber == this.stringNumber;
        }

        public int hashCode() {
            return this.stringNumber;
        }

        public int getStringNumber() {
            return this.stringNumber;
        }

        public String toString() {
            return "$" + this.stringNumber;
        }
    }

    public static final class Builder {
        private List<Object> symbols = new ArrayList<Object>();
        private Integer lengthOfOrigin;
        private int count;

        private Builder() {
        }

        public void add(List<Block> list) {
            this.symbols.addAll(list);
            this.symbols.add(new Terminator(this.count));
            ++this.count;
            if (this.lengthOfOrigin == null) {
                this.lengthOfOrigin = this.symbols.size();
            }
        }

        public TextSet build() {
            return new TextSet(this.symbols, this.lengthOfOrigin);
        }
    }
}

