/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.tool.support.xss;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.springblade.core.tool.support.xss.HtmlFilter;
import org.springblade.core.tool.utils.Charsets;
import org.springblade.core.tool.utils.StringUtil;
import org.springblade.core.tool.utils.WebUtil;

public class XssHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    HttpServletRequest orgRequest;
    private static final HtmlFilter HTML_FILTER = new HtmlFilter();
    private final byte[] body;

    public XssHttpServletRequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        this.orgRequest = request;
        this.body = WebUtil.getRequestBytes(request);
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public ServletInputStream getInputStream() throws IOException {
        if (null == super.getHeader("Content-Type")) {
            return super.getInputStream();
        }
        if (!super.getHeader("Content-Type").equalsIgnoreCase("application/json") && !super.getHeader("Content-Type").equalsIgnoreCase("application/json;charset=UTF-8")) {
            return super.getInputStream();
        }
        String requestStr = WebUtil.getRequestStr(this.orgRequest, this.body);
        if (StringUtil.isBlank(requestStr)) {
            return super.getInputStream();
        }
        requestStr = this.xssEncode(requestStr);
        final ByteArrayInputStream bis = new ByteArrayInputStream(requestStr.getBytes(Charsets.UTF_8));
        return new ServletInputStream(){

            public boolean isFinished() {
                return true;
            }

            public boolean isReady() {
                return true;
            }

            public void setReadListener(ReadListener readListener) {
            }

            public int read() throws IOException {
                return bis.read();
            }
        };
    }

    public String getParameter(String name) {
        String value = super.getParameter(this.xssEncode(name));
        if (StringUtil.isNotBlank(value)) {
            value = this.xssEncode(value);
        }
        return value;
    }

    public String[] getParameterValues(String name) {
        String[] parameters = super.getParameterValues(name);
        if (parameters == null || parameters.length == 0) {
            return null;
        }
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = this.xssEncode(parameters[i]);
        }
        return parameters;
    }

    public Map<String, String[]> getParameterMap() {
        LinkedHashMap<String, String[]> map = new LinkedHashMap<String, String[]>();
        Map parameters = super.getParameterMap();
        for (String key : parameters.keySet()) {
            String[] values = (String[])parameters.get(key);
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.xssEncode(values[i]);
            }
            map.put(key, values);
        }
        return map;
    }

    public String getHeader(String name) {
        String value = super.getHeader(this.xssEncode(name));
        if (StringUtil.isNotBlank(value)) {
            value = this.xssEncode(value);
        }
        return value;
    }

    private String xssEncode(String input) {
        return HTML_FILTER.filter(input);
    }

    public HttpServletRequest getOrgRequest() {
        return this.orgRequest;
    }

    public static HttpServletRequest getOrgRequest(HttpServletRequest request) {
        if (request instanceof XssHttpServletRequestWrapper) {
            return ((XssHttpServletRequestWrapper)request).getOrgRequest();
        }
        return request;
    }
}

