/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.tool.support.xss;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.springblade.core.tool.support.xss.XssHttpServletRequestWrapper;
import org.springblade.core.tool.support.xss.XssProperties;

public class XssFilter
implements Filter {
    private XssProperties xssProperties;

    public void init(FilterConfig config) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String path = ((HttpServletRequest)request).getServletPath();
        if (this.xssProperties.getExcludePatterns().stream().anyMatch(path::contains)) {
            chain.doFilter(request, response);
        } else {
            XssHttpServletRequestWrapper xssRequest = new XssHttpServletRequestWrapper((HttpServletRequest)request);
            chain.doFilter((ServletRequest)xssRequest, response);
        }
    }

    public void destroy() {
    }

    public XssFilter(XssProperties xssProperties) {
        this.xssProperties = xssProperties;
    }
}

