/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.tool.utils;

import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Stream;

public class PlaceholderUtil {
    public static final String DEFAULT_PLACEHOLDER_PREFIX = "${";
    public static final String DEFAULT_PLACEHOLDER_SUFFIX = "}";
    private static final PlaceholderUtil DEFAULT_RESOLVER = new PlaceholderUtil();
    private String placeholderPrefix = "${";
    private String placeholderSuffix = "}";

    private PlaceholderUtil() {
    }

    private PlaceholderUtil(String placeholderPrefix, String placeholderSuffix) {
        this.placeholderPrefix = placeholderPrefix;
        this.placeholderSuffix = placeholderSuffix;
    }

    public static PlaceholderUtil getDefaultResolver() {
        return DEFAULT_RESOLVER;
    }

    public static PlaceholderUtil getResolver(String placeholderPrefix, String placeholderSuffix) {
        return new PlaceholderUtil(placeholderPrefix, placeholderSuffix);
    }

    public String resolve(String content, String ... values) {
        int start = content.indexOf(this.placeholderPrefix);
        if (start == -1) {
            return content;
        }
        int valueIndex = 0;
        StringBuilder result = new StringBuilder(content);
        while (start != -1) {
            int end = result.indexOf(this.placeholderSuffix);
            String replaceContent = values[valueIndex++];
            result.replace(start, end + this.placeholderSuffix.length(), replaceContent);
            start = result.indexOf(this.placeholderPrefix, start + replaceContent.length());
        }
        return result.toString();
    }

    public String resolve(String content, Object[] values) {
        return this.resolve(content, (String[])Stream.of(values).map(String::valueOf).toArray(String[]::new));
    }

    public String resolveByRule(String content, Function<String, String> rule) {
        int start = content.indexOf(this.placeholderPrefix);
        if (start == -1) {
            return content;
        }
        StringBuilder result = new StringBuilder(content);
        while (start != -1) {
            int end = result.indexOf(this.placeholderSuffix, start + 1);
            String placeholder = result.substring(start + this.placeholderPrefix.length(), end);
            String replaceContent = placeholder.trim().isEmpty() ? "" : rule.apply(placeholder);
            result.replace(start, end + this.placeholderSuffix.length(), replaceContent);
            start = result.indexOf(this.placeholderPrefix, start + replaceContent.length());
        }
        return result.toString();
    }

    public String resolveByMap(String content, Map<String, Object> valueMap) {
        return this.resolveByRule(content, placeholderValue -> String.valueOf(valueMap.get(placeholderValue)));
    }

    public String resolveByProperties(String content, Properties properties) {
        return this.resolveByRule(content, properties::getProperty);
    }
}

