/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.tool.utils;

import java.math.BigInteger;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;

public class SM2Util {
    private static final ECDomainParameters DOMAIN_PARAMS;

    public static AsymmetricCipherKeyPair generateKeyPair() {
        ECKeyPairGenerator generator = new ECKeyPairGenerator();
        generator.init((KeyGenerationParameters)new ECKeyGenerationParameters(DOMAIN_PARAMS, new SecureRandom()));
        return generator.generateKeyPair();
    }

    public static byte[] encrypt(String input, String publicKey) {
        return SM2Util.encrypt(input, SM2Util.stringToPublicKey(publicKey));
    }

    public static byte[] encrypt(String input, ECPublicKeyParameters publicKey) {
        try {
            SM2Engine engine = new SM2Engine();
            engine.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)publicKey, new SecureRandom()));
            byte[] inputBytes = input.getBytes();
            return engine.processBlock(inputBytes, 0, inputBytes.length);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String decrypt(String encrypted, String privateKey) {
        return SM2Util.decrypt(Hex.decode((String)encrypted), privateKey);
    }

    public static String decrypt(byte[] encrypted, String privateKey) {
        return SM2Util.decrypt(encrypted, SM2Util.stringToPrivateKey(privateKey));
    }

    public static String decrypt(byte[] encrypted, ECPrivateKeyParameters privateKey) {
        try {
            SM2Engine engine = new SM2Engine();
            engine.init(false, (CipherParameters)privateKey);
            byte[] decryptedBytes = engine.processBlock(encrypted, 0, encrypted.length);
            return new String(decryptedBytes);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] sign(String input, String privateKey) {
        return SM2Util.sign(input, SM2Util.stringToPrivateKey(privateKey));
    }

    public static byte[] sign(String input, ECPrivateKeyParameters privateKey) {
        try {
            SM2Signer signer = new SM2Signer();
            signer.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)privateKey, new SecureRandom()));
            byte[] inputBytes = input.getBytes();
            signer.update(inputBytes, 0, inputBytes.length);
            return signer.generateSignature();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean verify(String input, byte[] signature, String publicKey) {
        return SM2Util.verify(input, signature, SM2Util.stringToPublicKey(publicKey));
    }

    public static boolean verify(String input, byte[] signature, ECPublicKeyParameters publicKey) {
        try {
            SM2Signer signer = new SM2Signer();
            signer.init(false, (CipherParameters)publicKey);
            byte[] inputBytes = input.getBytes();
            signer.update(inputBytes, 0, inputBytes.length);
            return signer.verifySignature(signature);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getPublicKeyString(AsymmetricCipherKeyPair keyPair) {
        ECPublicKeyParameters ecPublicKeyParameters = (ECPublicKeyParameters)keyPair.getPublic();
        return Hex.toHexString((byte[])ecPublicKeyParameters.getQ().getEncoded(false));
    }

    public static String getPrivateKeyString(AsymmetricCipherKeyPair keyPair) {
        ECPrivateKeyParameters ecPrivateKeyParameters = (ECPrivateKeyParameters)keyPair.getPrivate();
        return Hex.toHexString((byte[])ecPrivateKeyParameters.getD().toByteArray());
    }

    public static ECPublicKeyParameters stringToPublicKey(String data) {
        return new ECPublicKeyParameters(DOMAIN_PARAMS.getCurve().decodePoint(Hex.decode((String)data)), DOMAIN_PARAMS);
    }

    public static ECPrivateKeyParameters stringToPrivateKey(String data) {
        return new ECPrivateKeyParameters(new BigInteger(Hex.decode((String)data)), DOMAIN_PARAMS);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        X9ECParameters spec = GMNamedCurves.getByName((String)"sm2p256v1");
        DOMAIN_PARAMS = new ECDomainParameters(spec.getCurve(), spec.getG(), spec.getN(), spec.getH());
    }
}

