/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.tool.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springblade.core.tool.jackson.AbstractReadWriteJackson2HttpMessageConverter;
import org.springblade.core.tool.jackson.BladeBeanSerializerModifier;
import org.springblade.core.tool.jackson.BladeJacksonProperties;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;

public class MappingApiJackson2HttpMessageConverter
extends AbstractReadWriteJackson2HttpMessageConverter {
    @Nullable
    private String jsonPrefix;

    public MappingApiJackson2HttpMessageConverter(ObjectMapper objectMapper, BladeJacksonProperties properties) {
        super(objectMapper, MappingApiJackson2HttpMessageConverter.initWriteObjectMapper(objectMapper), MappingApiJackson2HttpMessageConverter.initMediaType(properties));
    }

    private static List<MediaType> initMediaType(BladeJacksonProperties properties) {
        ArrayList<MediaType> supportedMediaTypes = new ArrayList<MediaType>();
        supportedMediaTypes.add(MediaType.APPLICATION_JSON);
        supportedMediaTypes.add(new MediaType("application", "*+json"));
        if (Boolean.TRUE.equals(properties.getSupportTextPlain())) {
            supportedMediaTypes.add(MediaType.TEXT_PLAIN);
        }
        return supportedMediaTypes;
    }

    private static ObjectMapper initWriteObjectMapper(ObjectMapper readObjectMapper) {
        ObjectMapper writeObjectMapper = readObjectMapper.copy();
        writeObjectMapper.setSerializerFactory(writeObjectMapper.getSerializerFactory().withSerializerModifier((BeanSerializerModifier)new BladeBeanSerializerModifier()));
        writeObjectMapper.getSerializerProvider().setNullValueSerializer(BladeBeanSerializerModifier.NullJsonSerializers.STRING_JSON_SERIALIZER);
        return writeObjectMapper;
    }

    public void setJsonPrefix(String jsonPrefix) {
        this.jsonPrefix = jsonPrefix;
    }

    public void setPrefixJson(boolean prefixJson) {
        this.jsonPrefix = prefixJson ? ")]}', " : null;
    }

    protected void writePrefix(JsonGenerator generator, Object object) throws IOException {
        if (this.jsonPrefix != null) {
            generator.writeRaw(this.jsonPrefix);
        }
    }
}

