/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.tool.utils;

import java.io.IOException;
import org.springblade.core.tool.utils.Exceptions;
import org.springblade.core.tool.utils.IoUtil;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.FileUrlResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.util.Assert;
import org.springframework.util.ResourceUtils;

public class ResourceUtil
extends ResourceUtils {
    public static final String HTTP_REGEX = "^https?:.+$";
    public static final String FTP_URL_PREFIX = "ftp:";

    public static Resource getResource(String resourceLocation) throws IOException {
        Assert.notNull((Object)resourceLocation, (String)"Resource location must not be null");
        if (resourceLocation.startsWith("classpath:")) {
            String path = resourceLocation.substring("classpath:".length());
            return new ClassPathResource(path);
        }
        if (resourceLocation.startsWith(FTP_URL_PREFIX)) {
            return new UrlResource(resourceLocation);
        }
        if (resourceLocation.matches(HTTP_REGEX)) {
            return new UrlResource(resourceLocation);
        }
        if (resourceLocation.startsWith("file:")) {
            return new FileUrlResource(resourceLocation);
        }
        return new FileSystemResource(resourceLocation);
    }

    public static String getAsString(String resourceLocation) {
        try {
            Resource resource = ResourceUtil.getResource(resourceLocation);
            return IoUtil.toString(resource.getInputStream());
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }
}

