/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.support.converter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.converter.AbstractMessageConverter;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.oxm.XmlMappingException;
import org.springframework.util.Assert;

public class MarshallingMessageConverter
extends AbstractMessageConverter
implements InitializingBean {
    private volatile Marshaller marshaller;
    private volatile Unmarshaller unmarshaller;
    private volatile String contentType;

    public MarshallingMessageConverter() {
    }

    public MarshallingMessageConverter(Marshaller marshaller) {
        Assert.notNull((Object)marshaller, (String)"marshaller must not be null");
        if (!(marshaller instanceof Unmarshaller)) {
            throw new IllegalArgumentException("Marshaller [" + marshaller + "] does not implement the Unmarshaller " + "interface. Please set an Unmarshaller explicitly by using the " + "MarshallingMessageConverter(Marshaller, Unmarshaller) constructor.");
        }
        this.marshaller = marshaller;
        this.unmarshaller = (Unmarshaller)marshaller;
    }

    public MarshallingMessageConverter(Marshaller marshaller, Unmarshaller unmarshaller) {
        Assert.notNull((Object)marshaller, (String)"marshaller must not be null");
        Assert.notNull((Object)unmarshaller, (String)"unmarshaller must not be null");
        this.marshaller = marshaller;
        this.unmarshaller = unmarshaller;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setMarshaller(Marshaller marshaller) {
        Assert.notNull((Object)marshaller, (String)"marshaller must not be null");
        this.marshaller = marshaller;
    }

    public void setUnmarshaller(Unmarshaller unmarshaller) {
        Assert.notNull((Object)unmarshaller, (String)"unmarshaller must not be null");
        this.unmarshaller = unmarshaller;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.marshaller, (String)"Property 'marshaller' is required");
        Assert.notNull((Object)this.unmarshaller, (String)"Property 'unmarshaller' is required");
    }

    @Override
    protected Message createMessage(Object object, MessageProperties messageProperties) throws MessageConversionException {
        try {
            if (this.contentType != null) {
                messageProperties.setContentType(this.contentType);
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            StreamResult streamResult = new StreamResult(bos);
            this.marshaller.marshal(object, (Result)streamResult);
            return new Message(bos.toByteArray(), messageProperties);
        }
        catch (XmlMappingException ex) {
            throw new MessageConversionException("Could not marshal [" + object + "]", ex);
        }
        catch (IOException ex) {
            throw new MessageConversionException("Could not marshal  [" + object + "]", ex);
        }
    }

    @Override
    public Object fromMessage(Message message) throws MessageConversionException {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(message.getBody());
            StreamSource source = new StreamSource(bis);
            return this.unmarshaller.unmarshal((Source)source);
        }
        catch (IOException ex) {
            throw new MessageConversionException("Could not access message content: " + message, ex);
        }
        catch (XmlMappingException ex) {
            throw new MessageConversionException("Could not unmarshal message: " + message, ex);
        }
    }
}

