/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.support.converter;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.JavaType;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.converter.AbstractJsonMessageConverter;
import org.springframework.amqp.support.converter.DefaultJavaTypeMapper;
import org.springframework.amqp.support.converter.JavaTypeMapper;
import org.springframework.amqp.support.converter.MessageConversionException;

public class JsonMessageConverter
extends AbstractJsonMessageConverter {
    private static Log log = LogFactory.getLog(JsonMessageConverter.class);
    private ObjectMapper jsonObjectMapper = new ObjectMapper();
    private JavaTypeMapper javaTypeMapper = new DefaultJavaTypeMapper();
    private boolean typeMapperSet;

    public JsonMessageConverter() {
        this.initializeJsonObjectMapper();
    }

    public JavaTypeMapper getJavaTypeMapper() {
        return this.javaTypeMapper;
    }

    public void setJavaTypeMapper(JavaTypeMapper javaTypeMapper) {
        this.javaTypeMapper = javaTypeMapper;
        this.typeMapperSet = true;
    }

    public void setJsonObjectMapper(ObjectMapper jsonObjectMapper) {
        this.jsonObjectMapper = jsonObjectMapper;
    }

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        super.setBeanClassLoader(classLoader);
        if (!this.typeMapperSet) {
            ((DefaultJavaTypeMapper)this.javaTypeMapper).setBeanClassLoader(classLoader);
        }
    }

    protected void initializeJsonObjectMapper() {
        this.jsonObjectMapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Override
    public Object fromMessage(Message message) throws MessageConversionException {
        Object content = null;
        MessageProperties properties = message.getMessageProperties();
        if (properties != null) {
            String contentType = properties.getContentType();
            if (contentType != null && contentType.contains("json")) {
                String encoding = properties.getContentEncoding();
                if (encoding == null) {
                    encoding = this.getDefaultCharset();
                }
                try {
                    if (this.getClassMapper() == null) {
                        JavaType targetJavaType = this.getJavaTypeMapper().toJavaType(message.getMessageProperties());
                        content = this.convertBytesToObject(message.getBody(), encoding, targetJavaType);
                    }
                    Class<?> targetClass = this.getClassMapper().toClass(message.getMessageProperties());
                    content = this.convertBytesToObject(message.getBody(), encoding, targetClass);
                }
                catch (IOException e) {
                    throw new MessageConversionException("Failed to convert Message content", e);
                }
            } else {
                log.warn((Object)("Could not convert incoming message with content-type [" + contentType + "]"));
            }
        }
        if (content == null) {
            content = message.getBody();
        }
        return content;
    }

    private Object convertBytesToObject(byte[] body, String encoding, JavaType targetJavaType) throws JsonParseException, JsonMappingException, IOException {
        String contentAsString = new String(body, encoding);
        return this.jsonObjectMapper.readValue(contentAsString, targetJavaType);
    }

    private Object convertBytesToObject(byte[] body, String encoding, Class<?> targetClass) throws JsonParseException, JsonMappingException, IOException {
        String contentAsString = new String(body, encoding);
        return this.jsonObjectMapper.readValue(contentAsString, this.jsonObjectMapper.constructType(targetClass));
    }

    @Override
    protected Message createMessage(Object objectToConvert, MessageProperties messageProperties) throws MessageConversionException {
        byte[] bytes = null;
        try {
            String jsonString = this.jsonObjectMapper.writeValueAsString(objectToConvert);
            bytes = jsonString.getBytes(this.getDefaultCharset());
        }
        catch (IOException e) {
            throw new MessageConversionException("Failed to convert Message content", e);
        }
        messageProperties.setContentType("application/json");
        messageProperties.setContentEncoding(this.getDefaultCharset());
        if (bytes != null) {
            messageProperties.setContentLength(bytes.length);
        }
        if (this.getClassMapper() == null) {
            this.getJavaTypeMapper().fromJavaType(this.jsonObjectMapper.constructType(objectToConvert.getClass()), messageProperties);
        } else {
            this.getClassMapper().fromClass(objectToConvert.getClass(), messageProperties);
        }
        return new Message(bytes, messageProperties);
    }
}

