/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import java.util.List;
import org.springframework.boot.test.mock.mockito.DefinitionsParser;
import org.springframework.boot.test.mock.mockito.MockitoContextCustomizer;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import org.springframework.test.context.TestContextAnnotationUtils;

class MockitoContextCustomizerFactory
implements ContextCustomizerFactory {
    MockitoContextCustomizerFactory() {
    }

    public ContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configAttributes) {
        DefinitionsParser parser = new DefinitionsParser();
        this.parseDefinitions(testClass, parser);
        return new MockitoContextCustomizer(parser.getDefinitions());
    }

    private void parseDefinitions(Class<?> testClass, DefinitionsParser parser) {
        parser.parse(testClass);
        if (TestContextAnnotationUtils.searchEnclosingClass(testClass)) {
            this.parseDefinitions(testClass.getEnclosingClass(), parser);
        }
    }
}

