/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.builder;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.initializer.ParentContextApplicationContextInitializer;
import org.springframework.boot.context.initializer.ServletContextApplicationContextInitializer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StringUtils;

public class SpringApplicationBuilder {
    private SpringApplication application;
    private ConfigurableApplicationContext context;
    private SpringApplicationBuilder parent;
    private AtomicBoolean running = new AtomicBoolean(false);
    private Set<Object> sources = new LinkedHashSet<Object>();
    private Set<String> defaultArgs = new LinkedHashSet<String>();
    private ConfigurableEnvironment environment;

    public SpringApplicationBuilder(Object ... sources) {
        this.application = new SpringApplication(sources);
    }

    public ConfigurableApplicationContext context() {
        return this.context;
    }

    public SpringApplication application() {
        return this.application;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurableApplicationContext run(String ... args) {
        if (this.parent != null) {
            this.addInitializers(true, new ParentContextApplicationContextInitializer((ApplicationContext)this.parent.run(args)));
        }
        if (this.running.get()) {
            return this.context;
        }
        if (this.running.compareAndSet(false, true)) {
            AtomicBoolean atomicBoolean = this.running;
            synchronized (atomicBoolean) {
                this.application.setSources(this.sources);
                this.context = this.application.run(args);
            }
        }
        return this.context;
    }

    public SpringApplicationBuilder child(Object ... sources) {
        SpringApplicationBuilder child = new SpringApplicationBuilder(new Object[0]);
        child.sources(sources);
        child.defaultArgs(this.defaultArgs.toArray(new String[this.defaultArgs.size()])).environment(this.environment);
        child.parent = this;
        this.web(false);
        this.showBanner(false);
        this.application.setSources(this.sources);
        return child;
    }

    public SpringApplicationBuilder parent(Object ... sources) {
        if (this.parent == null) {
            this.parent = new SpringApplicationBuilder(sources).web(false).defaultArgs(this.defaultArgs).environment(this.environment);
        } else {
            this.parent.sources(sources);
        }
        return this.parent;
    }

    private SpringApplicationBuilder runAndExtractParent(String ... args) {
        if (this.context == null) {
            this.run(args);
        }
        if (this.parent != null) {
            return this.parent;
        }
        throw new IllegalStateException("No parent defined yet (please use the other overloaded parent methods to set one)");
    }

    public SpringApplicationBuilder parent(ConfigurableApplicationContext parent) {
        this.parent = new SpringApplicationBuilder(new Object[0]);
        this.parent.context = parent;
        this.parent.running.set(true);
        this.addInitializers(true, new ParentContextApplicationContextInitializer((ApplicationContext)parent));
        return this;
    }

    public SpringApplicationBuilder sibling(Object ... sources) {
        return this.runAndExtractParent(new String[0]).child(sources);
    }

    public SpringApplicationBuilder sibling(Object[] sources, String ... args) {
        return this.runAndExtractParent(args).child(sources);
    }

    public SpringApplicationBuilder contextClass(Class<? extends ConfigurableApplicationContext> cls) {
        this.application.setApplicationContextClass(cls);
        return this;
    }

    public SpringApplicationBuilder sources(Object ... sources) {
        this.sources.addAll(new LinkedHashSet<Object>(Arrays.asList(sources)));
        return this;
    }

    public SpringApplicationBuilder sources(Class<?> ... sources) {
        this.sources.addAll(new LinkedHashSet(Arrays.asList(sources)));
        return this;
    }

    public SpringApplicationBuilder web(boolean webEnvironment) {
        this.application.setWebEnvironment(webEnvironment);
        return this;
    }

    public SpringApplicationBuilder logStartupInfo(boolean logStartupInfo) {
        this.application.setLogStartupInfo(logStartupInfo);
        return this;
    }

    public SpringApplicationBuilder showBanner(boolean showBanner) {
        this.application.setShowBanner(showBanner);
        return this;
    }

    public SpringApplicationBuilder main(Class<?> mainApplicationClass) {
        this.application.setMainApplicationClass(mainApplicationClass);
        return this;
    }

    public SpringApplicationBuilder addCommandLineProperties(boolean addCommandLineProperties) {
        this.application.setAddCommandLineProperties(addCommandLineProperties);
        return this;
    }

    public SpringApplicationBuilder defaultArgs(String ... defaultArgs) {
        this.defaultArgs.addAll(Arrays.asList(defaultArgs));
        this.application.setDefaultArgs(this.defaultArgs.toArray(new String[this.defaultArgs.size()]));
        if (this.parent != null) {
            this.parent.defaultArgs(defaultArgs);
            this.parent.environment(this.environment);
        }
        return this;
    }

    private SpringApplicationBuilder defaultArgs(Set<String> defaultArgs) {
        this.defaultArgs = defaultArgs;
        return this;
    }

    public SpringApplicationBuilder profiles(String ... profiles) {
        this.defaultArgs("--spring.profiles.active=" + StringUtils.arrayToCommaDelimitedString((Object[])profiles));
        return this;
    }

    public SpringApplicationBuilder beanNameGenerator(BeanNameGenerator beanNameGenerator) {
        this.application.setBeanNameGenerator(beanNameGenerator);
        return this;
    }

    public SpringApplicationBuilder environment(ConfigurableEnvironment environment) {
        this.application.setEnvironment(environment);
        this.environment = environment;
        return this;
    }

    public SpringApplicationBuilder resourceLoader(ResourceLoader resourceLoader) {
        this.application.setResourceLoader(resourceLoader);
        return this;
    }

    public SpringApplicationBuilder initializers(ApplicationContextInitializer<?> ... initializers) {
        for (ApplicationContextInitializer<?> initializer : initializers) {
            boolean prepend = false;
            if (initializer instanceof ParentContextApplicationContextInitializer || initializer instanceof ServletContextApplicationContextInitializer) {
                prepend = true;
            }
            this.addInitializers(prepend, initializer);
        }
        return this;
    }

    private void addInitializers(boolean prepend, ApplicationContextInitializer<?> ... initializers) {
        LinkedHashSet target = new LinkedHashSet();
        if (prepend) {
            target.addAll(Arrays.asList(initializers));
            target.addAll(this.application.getInitializers());
        } else {
            target.addAll(this.application.getInitializers());
            target.addAll(Arrays.asList(initializers));
        }
        this.application.setInitializers(target);
    }
}

