/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.config;

import java.io.IOException;
import java.util.Properties;
import org.springframework.boot.config.PropertySourceLoader;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class PropertiesPropertySourceLoader
implements PropertySourceLoader {
    @Override
    public boolean supports(Resource resource) {
        return resource.getFilename().endsWith(".properties");
    }

    @Override
    public PropertySource<?> load(Resource resource) {
        try {
            Properties properties = this.loadProperties(resource);
            return new PropertiesPropertySource(resource.getDescription(), properties);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Could not load properties from " + resource, ex);
        }
    }

    protected Properties loadProperties(Resource resource) throws IOException {
        return PropertiesLoaderUtils.loadProperties((Resource)resource);
    }
}

