/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.context.embedded.EmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.FilterRegistrationBean;
import org.springframework.boot.context.embedded.RegistrationBean;
import org.springframework.boot.context.embedded.ServletContextInitializer;
import org.springframework.boot.context.embedded.ServletListenerRegistrationBean;
import org.springframework.boot.context.embedded.ServletRegistrationBean;
import org.springframework.boot.context.embedded.WebApplicationContextServletContextAwareProcessor;
import org.springframework.context.ApplicationContextException;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.GenericWebApplicationContext;
import org.springframework.web.context.support.ServletContextResource;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class EmbeddedWebApplicationContext
extends GenericWebApplicationContext {
    public static final String DISPATCHER_SERVLET_NAME = "dispatcherServlet";
    private EmbeddedServletContainer embeddedServletContainer;
    private ServletConfig servletConfig;
    private String namespace;

    protected void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        beanFactory.addBeanPostProcessor((BeanPostProcessor)new WebApplicationContextServletContextAwareProcessor((ConfigurableWebApplicationContext)this));
        beanFactory.ignoreDependencyInterface(ServletContextAware.class);
    }

    public final void refresh() throws BeansException, IllegalStateException {
        try {
            super.refresh();
        }
        catch (RuntimeException e) {
            this.stopAndReleaseEmbeddedServletContainer();
            throw e;
        }
    }

    protected void onRefresh() {
        super.onRefresh();
        this.registerShutdownHook();
        this.createEmbeddedServletContainer();
    }

    protected void finishRefresh() {
        super.finishRefresh();
        this.startEmbeddedServletContainer();
    }

    protected void doClose() {
        super.doClose();
        this.stopAndReleaseEmbeddedServletContainer();
    }

    private synchronized void createEmbeddedServletContainer() {
        if (this.embeddedServletContainer == null && this.getServletContext() == null) {
            EmbeddedServletContainerFactory containerFactory = this.getEmbeddedServletContainerFactory();
            this.embeddedServletContainer = containerFactory.getEmbeddedServletContainer(this.getSelfInitializer());
        } else if (this.getServletContext() != null) {
            try {
                this.getSelfInitializer().onStartup(this.getServletContext());
            }
            catch (ServletException ex) {
                throw new ApplicationContextException("Cannot initialize servlet context", (Throwable)ex);
            }
        }
        WebApplicationContextUtils.registerWebApplicationScopes((ConfigurableListableBeanFactory)this.getBeanFactory(), (ServletContext)this.getServletContext());
        WebApplicationContextUtils.registerEnvironmentBeans((ConfigurableListableBeanFactory)this.getBeanFactory(), (ServletContext)this.getServletContext());
        this.initPropertySources();
    }

    protected EmbeddedServletContainerFactory getEmbeddedServletContainerFactory() {
        Object[] beanNames = this.getBeanFactory().getBeanNamesForType(EmbeddedServletContainerFactory.class);
        if (beanNames.length == 0) {
            throw new ApplicationContextException("Unable to start EmbeddedWebApplicationContext due to missing EmbeddedServletContainerFactory bean.");
        }
        if (beanNames.length > 1) {
            throw new ApplicationContextException("Unable to start EmbeddedWebApplicationContext due to multiple EmbeddedServletContainerFactory beans : " + StringUtils.arrayToCommaDelimitedString((Object[])beanNames));
        }
        return (EmbeddedServletContainerFactory)this.getBeanFactory().getBean(beanNames[0], EmbeddedServletContainerFactory.class);
    }

    private ServletContextInitializer getSelfInitializer() {
        return new ServletContextInitializer(){

            @Override
            public void onStartup(ServletContext servletContext) throws ServletException {
                EmbeddedWebApplicationContext.this.prepareEmbeddedWebApplicationContext(servletContext);
                for (ServletContextInitializer beans : EmbeddedWebApplicationContext.this.getServletContextInitializerBeans()) {
                    beans.onStartup(servletContext);
                }
            }
        };
    }

    protected Collection<ServletContextInitializer> getServletContextInitializerBeans() {
        RegistrationBean registration;
        String name;
        LinkedHashSet<ServletContextInitializer> initializers = new LinkedHashSet<ServletContextInitializer>();
        LinkedHashSet<Servlet> servletRegistrations = new LinkedHashSet<Servlet>();
        LinkedHashSet<Filter> filterRegistrations = new LinkedHashSet<Filter>();
        LinkedHashSet listenerRegistrations = new LinkedHashSet();
        for (Map.Entry<String, ServletContextInitializer> initializerBean : this.getOrderedBeansOfType(ServletContextInitializer.class)) {
            ServletContextInitializer servletContextInitializer = initializerBean.getValue();
            initializers.add(servletContextInitializer);
            if (servletContextInitializer instanceof ServletRegistrationBean) {
                servletRegistrations.add(((ServletRegistrationBean)servletContextInitializer).getServlet());
            }
            if (servletContextInitializer instanceof FilterRegistrationBean) {
                filterRegistrations.add(((FilterRegistrationBean)servletContextInitializer).getFilter());
            }
            if (!(servletContextInitializer instanceof ServletListenerRegistrationBean)) continue;
            listenerRegistrations.add(((ServletListenerRegistrationBean)servletContextInitializer).getListener());
        }
        List<Map.Entry<String, Servlet>> servletBeans = this.getOrderedBeansOfType(Servlet.class);
        for (Map.Entry<String, Servlet> entry : servletBeans) {
            String url;
            name = entry.getKey();
            Servlet servlet = entry.getValue();
            if (servletRegistrations.contains(servlet)) continue;
            String string = url = servletBeans.size() == 1 ? "/" : "/" + name + "/";
            if (name.equals(DISPATCHER_SERVLET_NAME)) {
                url = "/";
            }
            ServletRegistrationBean registration2 = new ServletRegistrationBean(servlet, url);
            registration2.setName(name);
            registration2.setMultipartConfig(this.getMultipartConfig());
            initializers.add(registration2);
        }
        for (Map.Entry<String, Servlet> entry : this.getOrderedBeansOfType(Filter.class)) {
            name = entry.getKey();
            Filter filter = (Filter)entry.getValue();
            if (filterRegistrations.contains(filter)) continue;
            registration = new FilterRegistrationBean(filter, new ServletRegistrationBean[0]);
            registration.setName(name);
            initializers.add(registration);
        }
        for (Map.Entry<String, Object> entry : this.getOrderedBeansOfType(EventListener.class)) {
            name = entry.getKey();
            EventListener listener = (EventListener)entry.getValue();
            if (!ServletListenerRegistrationBean.isSupportedType(listener) || filterRegistrations.contains(listener)) continue;
            registration = new ServletListenerRegistrationBean<EventListener>(listener);
            registration.setName(name);
            initializers.add(registration);
        }
        return initializers;
    }

    private MultipartConfigElement getMultipartConfig() {
        List<Map.Entry<String, MultipartConfigElement>> beans = this.getOrderedBeansOfType(MultipartConfigElement.class);
        if (beans.isEmpty()) {
            return null;
        }
        return beans.get(0).getValue();
    }

    protected void prepareEmbeddedWebApplicationContext(ServletContext servletContext) {
        Object rootContext = servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        if (rootContext != null) {
            if (rootContext == this) {
                throw new IllegalStateException("Cannot initialize context because there is already a root application context present - check whether you have multiple ServletContextInitializers!");
            }
            return;
        }
        Log logger = LogFactory.getLog(ContextLoader.class);
        servletContext.log("Initializing Spring embedded WebApplicationContext");
        try {
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)this);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Published root WebApplicationContext as ServletContext attribute with name [" + WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE + "]"));
            }
            this.setServletContext(servletContext);
            if (logger.isInfoEnabled()) {
                long elapsedTime = System.currentTimeMillis() - this.getStartupDate();
                logger.info((Object)("Root WebApplicationContext: initialization completed in " + elapsedTime + " ms"));
            }
        }
        catch (RuntimeException ex) {
            logger.error((Object)"Context initialization failed", (Throwable)ex);
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)ex);
            throw ex;
        }
        catch (Error err) {
            logger.error((Object)"Context initialization failed", (Throwable)err);
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)err);
            throw err;
        }
    }

    private <T> List<Map.Entry<String, T>> getOrderedBeansOfType(Class<T> type) {
        ArrayList<Map.Entry<String, T>> beans = new ArrayList<Map.Entry<String, T>>();
        Comparator comparator = new Comparator<Map.Entry<String, T>>(){

            @Override
            public int compare(Map.Entry<String, T> o1, Map.Entry<String, T> o2) {
                return AnnotationAwareOrderComparator.INSTANCE.compare(o1.getValue(), o2.getValue());
            }
        };
        beans.addAll(this.getBeanFactory().getBeansOfType(type, true, true).entrySet());
        Collections.sort(beans, comparator);
        return beans;
    }

    private void startEmbeddedServletContainer() {
        if (this.embeddedServletContainer != null) {
            this.embeddedServletContainer.start();
        }
    }

    private synchronized void stopAndReleaseEmbeddedServletContainer() {
        if (this.embeddedServletContainer != null) {
            try {
                this.embeddedServletContainer.stop();
                this.embeddedServletContainer = null;
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    protected Resource getResourceByPath(String path) {
        if (this.getServletContext() == null) {
            return new DefaultResourceLoader.ClassPathContextResource(path, this.getClassLoader());
        }
        return new ServletContextResource(this.getServletContext(), path);
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setServletConfig(ServletConfig servletConfig) {
        this.servletConfig = servletConfig;
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public EmbeddedServletContainer getEmbeddedServletContainer() {
        return this.embeddedServletContainer;
    }
}

