/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.Registration;
import org.springframework.boot.context.embedded.ServletContextInitializer;
import org.springframework.core.Conventions;
import org.springframework.util.Assert;

public abstract class RegistrationBean
implements ServletContextInitializer {
    private String name;
    private boolean asyncSupported = true;
    private Map<String, String> initParameters = new LinkedHashMap<String, String>();

    public void setName(String name) {
        Assert.hasLength((String)name, (String)"Name must not be empty");
        this.name = name;
    }

    public void setAsyncSupported(boolean asyncSupported) {
        this.asyncSupported = asyncSupported;
    }

    public boolean isAsyncSupported() {
        return this.asyncSupported;
    }

    public void setInitParameters(Map<String, String> initParameters) {
        Assert.notNull(initParameters, (String)"InitParameters must not be null");
        this.initParameters = new LinkedHashMap<String, String>(initParameters);
    }

    public Map<String, String> getInitParameters() {
        return this.initParameters;
    }

    public void addInitParameter(String name, String value) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        this.initParameters.put(name, value);
    }

    protected final String getOrDeduceName(Object value) {
        return this.name != null ? this.name : Conventions.getVariableName((Object)value);
    }

    protected void configure(Registration.Dynamic registration) {
        Assert.state((registration != null ? 1 : 0) != 0, (String)("Registration is null. Was something already registered for name=[" + this.name + "]?"));
        registration.setAsyncSupported(this.asyncSupported);
        if (this.initParameters.size() > 0) {
            registration.setInitParameters(this.initParameters);
        }
    }
}

