/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded.jetty;

import java.io.File;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.springframework.boot.context.embedded.AbstractEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.EmbeddedServletContainer;
import org.springframework.boot.context.embedded.ErrorPage;
import org.springframework.boot.context.embedded.MimeMappings;
import org.springframework.boot.context.embedded.ServletContextInitializer;
import org.springframework.boot.context.embedded.jetty.JettyEmbeddedServletContainer;
import org.springframework.boot.context.embedded.jetty.ServletContextInitializerConfiguration;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class JettyEmbeddedServletContainerFactory
extends AbstractEmbeddedServletContainerFactory
implements ResourceLoaderAware {
    private List<Configuration> configurations = new ArrayList<Configuration>();
    private ResourceLoader resourceLoader;

    public JettyEmbeddedServletContainerFactory() {
    }

    public JettyEmbeddedServletContainerFactory(int port) {
        super(port);
    }

    public JettyEmbeddedServletContainerFactory(String contextPath, int port) {
        super(contextPath, port);
    }

    @Override
    public EmbeddedServletContainer getEmbeddedServletContainer(ServletContextInitializer ... initializers) {
        String contextPath;
        WebAppContext context = new WebAppContext();
        if (this.getPort() == 0) {
            return EmbeddedServletContainer.NONE;
        }
        Server server = new Server(new InetSocketAddress(this.getAddress(), this.getPort()));
        if (this.resourceLoader != null) {
            context.setClassLoader(this.resourceLoader.getClassLoader());
        }
        context.setContextPath(StringUtils.hasLength((String)(contextPath = this.getContextPath())) ? contextPath : "/");
        this.configureDocumentRoot(context);
        if (this.isRegisterDefaultServlet()) {
            this.addDefaultServlet(context);
        }
        if (this.isRegisterJspServlet() && ClassUtils.isPresent((String)this.getJspServletClassName(), (ClassLoader)this.getClass().getClassLoader())) {
            this.addJspServlet(context);
        }
        ServletContextInitializer[] initializersToUse = this.mergeInitializers(initializers);
        Configuration[] configurations = this.getWebAppContextConfigurations(context, initializersToUse);
        context.setConfigurations(configurations);
        context.getSessionHandler().getSessionManager().setMaxInactiveInterval(this.getSessionTimeout());
        this.postProcessWebAppContext(context);
        server.setHandler((Handler)context);
        return this.getJettyEmbeddedServletContainer(server);
    }

    private void configureDocumentRoot(WebAppContext handler) {
        File root = this.getValidDocumentRoot();
        if (root != null) {
            try {
                handler.setBaseResource(Resource.newResource((File)root));
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    private void addDefaultServlet(WebAppContext context) {
        ServletHolder holder = new ServletHolder();
        holder.setName("default");
        holder.setClassName("org.eclipse.jetty.servlet.DefaultServlet");
        holder.setInitParameter("dirAllowed", "false");
        holder.setInitOrder(1);
        context.getServletHandler().addServletWithMapping(holder, "/");
        context.getServletHandler().getServletMapping("/").setDefault(true);
    }

    private void addJspServlet(WebAppContext context) {
        ServletHolder holder = new ServletHolder();
        holder.setName("jsp");
        holder.setClassName(this.getJspServletClassName());
        holder.setInitParameter("fork", "false");
        holder.setInitOrder(3);
        context.getServletHandler().addServlet(holder);
        ServletMapping mapping = new ServletMapping();
        mapping.setServletName("jsp");
        mapping.setPathSpecs(new String[]{"*.jsp", "*.jspx"});
        context.getServletHandler().addServletMapping(mapping);
    }

    protected Configuration[] getWebAppContextConfigurations(WebAppContext webAppContext, ServletContextInitializer ... initializers) {
        ArrayList<Configuration> configurations = new ArrayList<Configuration>();
        configurations.add(this.getServletContextInitializerConfiguration(webAppContext, initializers));
        configurations.addAll(this.getConfigurations());
        configurations.add(this.getErrorPageConfiguration());
        configurations.add(this.getMimeTypeConfiguration());
        return configurations.toArray(new Configuration[configurations.size()]);
    }

    private Configuration getErrorPageConfiguration() {
        return new AbstractConfiguration(){

            public void configure(WebAppContext context) throws Exception {
                ErrorHandler errorHandler = context.getErrorHandler();
                JettyEmbeddedServletContainerFactory.this.addJettyErrorPages(errorHandler, JettyEmbeddedServletContainerFactory.this.getErrorPages());
            }
        };
    }

    private Configuration getMimeTypeConfiguration() {
        return new AbstractConfiguration(){

            public void configure(WebAppContext context) throws Exception {
                MimeTypes mimeTypes = context.getMimeTypes();
                for (MimeMappings.Mapping mapping : JettyEmbeddedServletContainerFactory.this.getMimeMappings()) {
                    mimeTypes.addMimeMapping(mapping.getExtension(), mapping.getMimeType());
                }
            }
        };
    }

    protected Configuration getServletContextInitializerConfiguration(WebAppContext webAppContext, ServletContextInitializer ... initializers) {
        return new ServletContextInitializerConfiguration((ContextHandler)webAppContext, initializers);
    }

    protected void postProcessWebAppContext(WebAppContext webAppContext) {
    }

    protected JettyEmbeddedServletContainer getJettyEmbeddedServletContainer(Server server) {
        return new JettyEmbeddedServletContainer(server);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setConfigurations(Collection<? extends Configuration> configurations) {
        Assert.notNull(configurations, (String)"Configurations must not be null");
        this.configurations = new ArrayList<Configuration>(configurations);
    }

    public Collection<Configuration> getConfigurations() {
        return this.configurations;
    }

    public void addConfigurations(Configuration ... configurations) {
        Assert.notNull((Object)configurations, (String)"Configurations must not be null");
        this.configurations.addAll(Arrays.asList(configurations));
    }

    private void addJettyErrorPages(ErrorHandler errorHandler, Collection<ErrorPage> errorPages) {
        if (errorHandler instanceof ErrorPageErrorHandler) {
            ErrorPageErrorHandler handler = (ErrorPageErrorHandler)errorHandler;
            for (ErrorPage errorPage : errorPages) {
                if (errorPage.isGlobal()) {
                    handler.addErrorPage("org.eclipse.jetty.server.error_page.global", errorPage.getPath());
                    continue;
                }
                if (errorPage.getExceptionName() != null) {
                    handler.addErrorPage(errorPage.getExceptionName(), errorPage.getPath());
                    continue;
                }
                handler.addErrorPage(errorPage.getStatusCode(), errorPage.getPath());
            }
        }
    }
}

