/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded.tomcat;

import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.embedded.EmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerException;
import org.springframework.util.Assert;

public class TomcatEmbeddedServletContainer
implements EmbeddedServletContainer {
    private final Log logger = LogFactory.getLog(TomcatEmbeddedServletContainer.class);
    private static int containerCounter = 0;
    private final Tomcat tomcat;

    public TomcatEmbeddedServletContainer(Tomcat tomcat) {
        Assert.notNull((Object)tomcat, (String)"Tomcat Server must not be null");
        this.tomcat = tomcat;
        this.initialize();
    }

    private synchronized void initialize() throws EmbeddedServletContainerException {
        try {
            this.tomcat.start();
            try {
                Connector connector = this.tomcat.getConnector();
                connector.getProtocolHandler().stop();
            }
            catch (Exception e) {
                this.logger.error((Object)"Cannot pause connector: ", (Throwable)e);
            }
            Thread awaitThread = new Thread("container-" + containerCounter++){

                @Override
                public void run() {
                    TomcatEmbeddedServletContainer.this.tomcat.getServer().await();
                }
            };
            awaitThread.setDaemon(false);
            awaitThread.start();
        }
        catch (Exception ex) {
            throw new EmbeddedServletContainerException("Unable to start embdedded Tomcat", ex);
        }
    }

    @Override
    public void start() throws EmbeddedServletContainerException {
        Connector connector = this.tomcat.getConnector();
        if (connector != null) {
            try {
                connector.getProtocolHandler().start();
            }
            catch (Exception e) {
                this.logger.error((Object)"Cannot start connector: ", (Throwable)e);
            }
        }
    }

    @Override
    public synchronized void stop() throws EmbeddedServletContainerException {
        try {
            try {
                this.tomcat.stop();
            }
            catch (LifecycleException ex) {
                // empty catch block
            }
            this.tomcat.destroy();
        }
        catch (Exception ex) {
            throw new EmbeddedServletContainerException("Unable to stop embdedded Tomcat", ex);
        }
    }

    public Tomcat getTomcat() {
        return this.tomcat;
    }
}

