/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded;

import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import javax.servlet.Servlet;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.embedded.AnnotationConfigEmbeddedWebApplicationContext;
import org.springframework.boot.context.embedded.EmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.ServletRegistrationBean;
import org.springframework.boot.context.embedded.jetty.JettyEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.stereotype.Controller;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

public class EmbeddedServletContainerMvcIntegrationTests {
    private AnnotationConfigEmbeddedWebApplicationContext context;

    @After
    public void closeContext() {
        try {
            this.context.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void tomcat() throws Exception {
        this.context = new AnnotationConfigEmbeddedWebApplicationContext(new Class[]{TomcatEmbeddedServletContainerFactory.class, Config.class});
        this.doTest(this.context, "http://localhost:8080/hello");
    }

    @Test
    public void jetty() throws Exception {
        this.context = new AnnotationConfigEmbeddedWebApplicationContext(new Class[]{JettyEmbeddedServletContainerFactory.class, Config.class});
        this.doTest(this.context, "http://localhost:8080/hello");
    }

    @Test
    public void advancedConfig() throws Exception {
        this.context = new AnnotationConfigEmbeddedWebApplicationContext(new Class[]{AdvancedConfig.class});
        this.doTest(this.context, "http://localhost:8081/example/spring/hello");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTest(AnnotationConfigEmbeddedWebApplicationContext context, String url) throws Exception {
        SimpleClientHttpRequestFactory clientHttpRequestFactory = new SimpleClientHttpRequestFactory();
        ClientHttpRequest request = clientHttpRequestFactory.createRequest(new URI(url), HttpMethod.GET);
        ClientHttpResponse response = request.execute();
        try {
            String actual = StreamUtils.copyToString((InputStream)response.getBody(), (Charset)Charset.forName("UTF-8"));
            Assert.assertThat((Object)actual, (Matcher)Matchers.equalTo((Object)"Hello World"));
        }
        finally {
            response.close();
        }
    }

    public static void main(String[] args) {
        new AnnotationConfigEmbeddedWebApplicationContext(new Class[]{JettyEmbeddedServletContainerFactory.class, Config.class});
    }

    @Controller
    public static class HelloWorldController {
        @RequestMapping(value={"/hello"})
        @ResponseBody
        public String sayHello() {
            return "Hello World";
        }
    }

    @Configuration
    @EnableWebMvc
    @PropertySource(value={"classpath:/org/springframework/boot/context/embedded/conf.properties"})
    public static class AdvancedConfig {
        @Autowired
        private Environment env;

        @Bean
        public EmbeddedServletContainerFactory containerFactory() {
            JettyEmbeddedServletContainerFactory factory = new JettyEmbeddedServletContainerFactory();
            factory.setPort(((Integer)this.env.getProperty("port", Integer.class)).intValue());
            factory.setContextPath("/example");
            return factory;
        }

        @Bean
        public ServletRegistrationBean dispatcherRegistration() {
            ServletRegistrationBean registration = new ServletRegistrationBean((Servlet)this.dispatcherServlet(), new String[0]);
            registration.addUrlMappings(new String[]{"/spring/*"});
            return registration;
        }

        @Bean
        public DispatcherServlet dispatcherServlet() {
            DispatcherServlet dispatcherServlet = new DispatcherServlet();
            return dispatcherServlet;
        }

        @Bean
        public HelloWorldController helloWorldController() {
            return new HelloWorldController();
        }
    }

    @Configuration
    @EnableWebMvc
    public static class Config {
        @Bean
        public DispatcherServlet dispatcherServlet() {
            return new DispatcherServlet();
        }

        @Bean
        public HelloWorldController helloWorldController() {
            return new HelloWorldController();
        }
    }
}

