/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.BDDMockito;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.springframework.boot.context.embedded.MockServlet;
import org.springframework.boot.context.embedded.ServletRegistrationBean;

public class ServletRegistrationBeanTests {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private MockServlet servlet = new MockServlet();
    @Mock
    private ServletContext servletContext;
    @Mock
    private ServletRegistration.Dynamic registration;
    @Mock
    private FilterRegistration.Dynamic filterRegistration;

    @Before
    public void setupMocks() {
        MockitoAnnotations.initMocks((Object)this);
        BDDMockito.given((Object)this.servletContext.addServlet(Matchers.anyString(), (Servlet)Matchers.anyObject())).willReturn((Object)this.registration);
        BDDMockito.given((Object)this.servletContext.addFilter(Matchers.anyString(), (Filter)Matchers.anyObject())).willReturn((Object)this.filterRegistration);
    }

    @Test
    public void startupWithDefaults() throws Exception {
        ServletRegistrationBean bean = new ServletRegistrationBean((Servlet)this.servlet, new String[0]);
        bean.onStartup(this.servletContext);
        ((ServletContext)Mockito.verify((Object)this.servletContext)).addServlet("mockServlet", (Servlet)this.servlet);
        ((ServletRegistration.Dynamic)Mockito.verify((Object)this.registration)).setAsyncSupported(true);
        ((ServletRegistration.Dynamic)Mockito.verify((Object)this.registration)).addMapping(new String[]{"/*"});
    }

    @Test
    public void startupWithSpecifiedValues() throws Exception {
        ServletRegistrationBean bean = new ServletRegistrationBean();
        bean.setName("test");
        bean.setServlet((Servlet)this.servlet);
        bean.setAsyncSupported(false);
        bean.setInitParameters(Collections.singletonMap("a", "b"));
        bean.addInitParameter("c", "d");
        bean.setUrlMappings(new LinkedHashSet<String>(Arrays.asList("/a", "/b")));
        bean.addUrlMappings(new String[]{"/c"});
        bean.setLoadOnStartup(10);
        bean.onStartup(this.servletContext);
        ((ServletContext)Mockito.verify((Object)this.servletContext)).addServlet("test", (Servlet)this.servlet);
        ((ServletRegistration.Dynamic)Mockito.verify((Object)this.registration)).setAsyncSupported(false);
        HashMap<String, String> expectedInitParameters = new HashMap<String, String>();
        expectedInitParameters.put("a", "b");
        expectedInitParameters.put("c", "d");
        ((ServletRegistration.Dynamic)Mockito.verify((Object)this.registration)).setInitParameters(expectedInitParameters);
        ((ServletRegistration.Dynamic)Mockito.verify((Object)this.registration)).addMapping(new String[]{"/a", "/b", "/c"});
        ((ServletRegistration.Dynamic)Mockito.verify((Object)this.registration)).setLoadOnStartup(10);
    }

    @Test
    public void specificName() throws Exception {
        ServletRegistrationBean bean = new ServletRegistrationBean();
        bean.setName("specificName");
        bean.setServlet((Servlet)this.servlet);
        bean.onStartup(this.servletContext);
        ((ServletContext)Mockito.verify((Object)this.servletContext)).addServlet("specificName", (Servlet)this.servlet);
    }

    @Test
    public void deducedName() throws Exception {
        ServletRegistrationBean bean = new ServletRegistrationBean();
        bean.setServlet((Servlet)this.servlet);
        bean.onStartup(this.servletContext);
        ((ServletContext)Mockito.verify((Object)this.servletContext)).addServlet("mockServlet", (Servlet)this.servlet);
    }

    @Test
    public void setServletMustNotBeNull() throws Exception {
        ServletRegistrationBean bean = new ServletRegistrationBean();
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Servlet must not be null");
        bean.onStartup(this.servletContext);
    }

    @Test
    public void createServletMustNotBeNull() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Servlet must not be null");
        new ServletRegistrationBean(null, new String[0]);
    }

    @Test
    public void setMappingMustNotBeNull() throws Exception {
        ServletRegistrationBean bean = new ServletRegistrationBean((Servlet)this.servlet, new String[0]);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("UrlMappings must not be null");
        bean.setUrlMappings(null);
    }

    @Test
    public void createMappingMustNotBeNull() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("UrlMappings must not be null");
        new ServletRegistrationBean((Servlet)this.servlet, (String[])null);
    }

    @Test
    public void addMappingMustNotBeNull() throws Exception {
        ServletRegistrationBean bean = new ServletRegistrationBean((Servlet)this.servlet, new String[0]);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("UrlMappings must not be null");
        bean.addUrlMappings((String[])null);
    }

    @Test
    public void setMappingReplacesValue() throws Exception {
        ServletRegistrationBean bean = new ServletRegistrationBean((Servlet)this.servlet, new String[]{"/a", "/b"});
        bean.setUrlMappings(new LinkedHashSet<String>(Arrays.asList("/c", "/d")));
        bean.onStartup(this.servletContext);
        ((ServletRegistration.Dynamic)Mockito.verify((Object)this.registration)).addMapping(new String[]{"/c", "/d"});
    }

    @Test
    public void modifyInitParameters() throws Exception {
        ServletRegistrationBean bean = new ServletRegistrationBean((Servlet)this.servlet, new String[]{"/a", "/b"});
        bean.addInitParameter("a", "b");
        bean.getInitParameters().put("a", "c");
        bean.onStartup(this.servletContext);
        ((ServletRegistration.Dynamic)Mockito.verify((Object)this.registration)).setInitParameters(Collections.singletonMap("a", "c"));
    }
}

