/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded;

import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.boot.context.embedded.MockEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.XmlEmbeddedWebApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class XmlEmbeddedWebApplicationContextTests {
    private static final String PATH = XmlEmbeddedWebApplicationContextTests.class.getPackage().getName().replace(".", "/") + "/";
    private static final String FILE = "exampleEmbeddedWebApplicationConfiguration.xml";
    private XmlEmbeddedWebApplicationContext context;

    @Test
    public void createFromResource() throws Exception {
        this.context = new XmlEmbeddedWebApplicationContext(new Resource[]{new ClassPathResource(FILE, this.getClass())});
        this.verifyContext();
    }

    @Test
    public void createFromResourceLocation() throws Exception {
        this.context = new XmlEmbeddedWebApplicationContext(new String[]{PATH + FILE});
        this.verifyContext();
    }

    @Test
    public void createFromRelativeResourceLocation() throws Exception {
        this.context = new XmlEmbeddedWebApplicationContext(this.getClass(), new String[]{FILE});
        this.verifyContext();
    }

    @Test
    public void loadAndRefreshFromResource() throws Exception {
        this.context = new XmlEmbeddedWebApplicationContext();
        this.context.load(new Resource[]{new ClassPathResource(FILE, this.getClass())});
        this.context.refresh();
        this.verifyContext();
    }

    @Test
    public void loadAndRefreshFromResourceLocation() throws Exception {
        this.context = new XmlEmbeddedWebApplicationContext();
        this.context.load(new String[]{PATH + FILE});
        this.context.refresh();
        this.verifyContext();
    }

    @Test
    public void loadAndRefreshFromRelativeResourceLocation() throws Exception {
        this.context = new XmlEmbeddedWebApplicationContext();
        this.context.load(this.getClass(), new String[]{FILE});
        this.context.refresh();
        this.verifyContext();
    }

    private void verifyContext() {
        MockEmbeddedServletContainerFactory containerFactory = (MockEmbeddedServletContainerFactory)((Object)this.context.getBean(MockEmbeddedServletContainerFactory.class));
        Servlet servlet = (Servlet)this.context.getBean(Servlet.class);
        ((ServletContext)Mockito.verify((Object)containerFactory.getServletContext())).addServlet("servlet", servlet);
    }
}

