/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded.jetty;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.springframework.boot.context.embedded.AbstractEmbeddedServletContainerFactoryTests;
import org.springframework.boot.context.embedded.ServletContextInitializer;
import org.springframework.boot.context.embedded.jetty.JettyEmbeddedServletContainer;
import org.springframework.boot.context.embedded.jetty.JettyEmbeddedServletContainerFactory;

public class JettyEmbeddedServletContainerFactoryTests
extends AbstractEmbeddedServletContainerFactoryTests {
    protected JettyEmbeddedServletContainerFactory getFactory() {
        return new JettyEmbeddedServletContainerFactory();
    }

    @Test
    public void jettyConfigurations() throws Exception {
        JettyEmbeddedServletContainerFactory factory = this.getFactory();
        Configuration[] configurations = new Configuration[4];
        for (int i = 0; i < configurations.length; ++i) {
            configurations[i] = (Configuration)Mockito.mock(Configuration.class);
        }
        factory.setConfigurations(Arrays.asList(configurations[0], configurations[1]));
        factory.addConfigurations(new Configuration[]{configurations[2], configurations[3]});
        this.container = factory.getEmbeddedServletContainer(new ServletContextInitializer[0]);
        InOrder ordered = Mockito.inOrder((Object[])configurations);
        for (Configuration configuration : configurations) {
            ((Configuration)ordered.verify((Object)configuration)).configure((WebAppContext)Matchers.anyObject());
        }
    }

    @Test
    public void sessionTimeout() throws Exception {
        JettyEmbeddedServletContainerFactory factory = this.getFactory();
        factory.setSessionTimeout(10);
        this.assertTimeout(factory, 10);
    }

    @Test
    public void sessionTimeoutInMins() throws Exception {
        JettyEmbeddedServletContainerFactory factory = this.getFactory();
        factory.setSessionTimeout(1, TimeUnit.MINUTES);
        this.assertTimeout(factory, 60);
    }

    private void assertTimeout(JettyEmbeddedServletContainerFactory factory, int expected) {
        this.container = factory.getEmbeddedServletContainer(new ServletContextInitializer[0]);
        JettyEmbeddedServletContainer jettyContainer = (JettyEmbeddedServletContainer)this.container;
        Handler[] handlers = jettyContainer.getServer().getChildHandlersByClass(WebAppContext.class);
        WebAppContext webAppContext = (WebAppContext)handlers[0];
        int actual = webAppContext.getSessionHandler().getSessionManager().getMaxInactiveInterval();
        Assert.assertThat((Object)actual, (Matcher)org.hamcrest.Matchers.equalTo((Object)expected));
    }
}

