/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded.properties;

import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.boot.bind.RelaxedDataBinder;
import org.springframework.boot.context.embedded.properties.ServerProperties;

public class ServerPropertiesTests {
    private ServerProperties properties = new ServerProperties();

    @Test
    public void testAddressBinding() throws Exception {
        RelaxedDataBinder binder = new RelaxedDataBinder((Object)this.properties, "server");
        binder.bind((PropertyValues)new MutablePropertyValues(Collections.singletonMap("server.address", "127.0.0.1")));
        Assert.assertFalse((boolean)binder.getBindingResult().hasErrors());
        Assert.assertEquals((Object)InetAddress.getByName("127.0.0.1"), (Object)this.properties.getAddress());
    }

    @Test
    public void testPortBinding() throws Exception {
        new RelaxedDataBinder((Object)this.properties, "server").bind((PropertyValues)new MutablePropertyValues(Collections.singletonMap("server.port", "9000")));
        Assert.assertEquals((long)9000L, (long)this.properties.getPort().intValue());
    }

    @Test
    public void testTomcatBinding() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("server.tomcat.access_log_pattern", "%h %t '%r' %s %b");
        map.put("server.tomcat.protocol_header", "X-Forwarded-Protocol");
        map.put("server.tomcat.remote_ip_header", "Remote-Ip");
        new RelaxedDataBinder((Object)this.properties, "server").bind((PropertyValues)new MutablePropertyValues(map));
        Assert.assertEquals((Object)"%h %t '%r' %s %b", (Object)this.properties.getTomcat().getAccessLogPattern());
        Assert.assertEquals((Object)"Remote-Ip", (Object)this.properties.getTomcat().getRemoteIpHeader());
        Assert.assertEquals((Object)"X-Forwarded-Protocol", (Object)this.properties.getTomcat().getProtocolHeader());
    }
}

