/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.initializer;

import java.util.HashMap;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.boot.context.initializer.ConfigFileApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.StaticApplicationContext;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.SimpleCommandLinePropertySource;

public class ConfigFileApplicationContextInitializerTests {
    private StaticApplicationContext context = new StaticApplicationContext();
    private ConfigFileApplicationContextInitializer initializer = new ConfigFileApplicationContextInitializer();

    @After
    public void cleanup() {
        System.clearProperty("my.property");
    }

    @Test
    public void loadPropertiesFile() throws Exception {
        this.initializer.setNames("testproperties");
        this.initializer.initialize((ConfigurableApplicationContext)this.context);
        String property = this.context.getEnvironment().getProperty("my.property");
        Assert.assertThat((Object)property, (Matcher)Matchers.equalTo((Object)"frompropertiesfile"));
    }

    @Test
    public void loadTwoPropertiesFiles() throws Exception {
        this.initializer.setNames("testproperties,moreproperties");
        this.initializer.initialize((ConfigurableApplicationContext)this.context);
        String property = this.context.getEnvironment().getProperty("my.property");
        Assert.assertThat((Object)property, (Matcher)Matchers.equalTo((Object)"frommorepropertiesfile"));
    }

    @Test
    public void loadYamlFile() throws Exception {
        this.initializer.setNames("testyaml");
        this.initializer.initialize((ConfigurableApplicationContext)this.context);
        String property = this.context.getEnvironment().getProperty("my.property");
        Assert.assertThat((Object)property, (Matcher)Matchers.equalTo((Object)"fromyamlfile"));
        Assert.assertThat((Object)this.context.getEnvironment().getProperty("my.array[0]"), (Matcher)Matchers.equalTo((Object)"1"));
        Assert.assertThat((Object)this.context.getEnvironment().getProperty("my.array"), (Matcher)Matchers.nullValue(String.class));
    }

    @Test
    public void commandLineWins() throws Exception {
        this.context.getEnvironment().getPropertySources().addFirst((PropertySource)new SimpleCommandLinePropertySource(new String[]{"--my.property=fromcommandline"}));
        this.initializer.setNames("testproperties");
        this.initializer.initialize((ConfigurableApplicationContext)this.context);
        String property = this.context.getEnvironment().getProperty("my.property");
        Assert.assertThat((Object)property, (Matcher)Matchers.equalTo((Object)"fromcommandline"));
    }

    @Test
    public void systemPropertyWins() throws Exception {
        System.setProperty("my.property", "fromsystem");
        this.initializer.setNames("testproperties");
        this.initializer.initialize((ConfigurableApplicationContext)this.context);
        String property = this.context.getEnvironment().getProperty("my.property");
        Assert.assertThat((Object)property, (Matcher)Matchers.equalTo((Object)"fromsystem"));
    }

    @Test
    public void loadPropertiesThenProfileProperties() throws Exception {
        this.initializer.setNames("enableprofile");
        this.initializer.initialize((ConfigurableApplicationContext)this.context);
        String property = this.context.getEnvironment().getProperty("my.property");
        Assert.assertThat((Object)property, (Matcher)Matchers.equalTo((Object)"fromprofilepropertiesfile"));
    }

    @Test
    public void profilePropertiesUsedInPlaceholders() throws Exception {
        this.initializer.setNames("enableprofile");
        this.initializer.initialize((ConfigurableApplicationContext)this.context);
        String property = this.context.getEnvironment().getProperty("one.more");
        Assert.assertThat((Object)property, (Matcher)Matchers.equalTo((Object)"fromprofilepropertiesfile"));
    }

    @Test
    public void yamlProfiles() throws Exception {
        this.initializer.setNames("testprofiles");
        this.context.getEnvironment().setActiveProfiles(new String[]{"dev"});
        this.initializer.initialize((ConfigurableApplicationContext)this.context);
        String property = this.context.getEnvironment().getProperty("my.property");
        Assert.assertThat((Object)property, (Matcher)Matchers.equalTo((Object)"fromdevprofile"));
        property = this.context.getEnvironment().getProperty("my.other");
        Assert.assertThat((Object)property, (Matcher)Matchers.equalTo((Object)"notempty"));
    }

    @Test
    public void yamlSetsProfiles() throws Exception {
        this.initializer.setNames("testsetprofiles");
        this.initializer.initialize((ConfigurableApplicationContext)this.context);
        String property = this.context.getEnvironment().getProperty("my.property");
        Assert.assertThat((Object)property, (Matcher)Matchers.equalTo((Object)"fromdevprofile"));
    }

    @Test
    public void specificNameAndProfileFromExistingSource() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("spring.profiles.active", "specificprofile");
        map.put("spring.config.name", "specificfile");
        MapPropertySource source = new MapPropertySource("map", map);
        this.context.getEnvironment().getPropertySources().addFirst((PropertySource)source);
        this.initializer.initialize((ConfigurableApplicationContext)this.context);
        String property = this.context.getEnvironment().getProperty("my.property");
        Assert.assertThat((Object)property, (Matcher)Matchers.equalTo((Object)"fromspecificpropertiesfile"));
    }

    @Test
    public void specificResource() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("spring.config.location", "classpath:/specificlocation.properties");
        MapPropertySource source = new MapPropertySource("map", map);
        this.context.getEnvironment().getPropertySources().addFirst((PropertySource)source);
        this.initializer.initialize((ConfigurableApplicationContext)this.context);
        String property = this.context.getEnvironment().getProperty("my.property");
        Assert.assertThat((Object)property, (Matcher)Matchers.equalTo((Object)"fromspecificlocation"));
    }

    @Test
    public void defaultApplicationProperties() throws Exception {
    }
}

