/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.initializer;

import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.springframework.boot.TestUtils;
import org.springframework.boot.context.initializer.FileEncodingApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.StaticApplicationContext;

public class FileEncodingApplicationContextInitializerTests {
    private FileEncodingApplicationContextInitializer initializer = new FileEncodingApplicationContextInitializer();
    private ConfigurableApplicationContext context;

    @Before
    public void init() {
        this.context = new StaticApplicationContext();
    }

    @Test(expected=IllegalStateException.class)
    public void testIllegalState() {
        TestUtils.addEnviroment(this.context, "spring.mandatory_file_encoding:FOO");
        this.initializer.initialize(this.context);
    }

    @Test
    public void testSunnyDayNothingMandated() {
        this.initializer.initialize(this.context);
    }

    @Test
    public void testSunnyDayMandated() {
        Assume.assumeNotNull((Object[])new Object[]{System.getProperty("file.encoding")});
        TestUtils.addEnviroment(this.context, "spring.mandatory_file_encoding:" + System.getProperty("file.encoding"));
        this.initializer.initialize(this.context);
    }
}

