/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.test;

import java.util.Properties;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class EnableConfigurationPropertiesTests {
    private AnnotationConfigApplicationContext context;

    @Before
    public void open() throws Exception {
        this.context = new AnnotationConfigApplicationContext();
        this.context.getEnvironment().getPropertySources().addFirst((PropertySource)new PropertiesPropertySource("props", this.getProperties("external.name=foo\nanother.name=bar")));
    }

    @After
    public void close() {
        if (this.context != null) {
            this.context.close();
        }
    }

    @Test
    public void testSimpleAutoConfig() throws Exception {
        this.context.register(new Class[]{ExampleConfig.class});
        this.context.refresh();
        Assert.assertEquals((Object)"foo", (Object)((External)this.context.getBean(External.class)).getName());
    }

    @Test
    public void testExplicitType() throws Exception {
        this.context.register(new Class[]{AnotherExampleConfig.class});
        this.context.refresh();
        Assert.assertEquals((Object)"foo", (Object)((External)this.context.getBean(External.class)).getName());
    }

    @Test
    public void testMultipleExplicitTypes() throws Exception {
        this.context.register(new Class[]{FurtherExampleConfig.class});
        this.context.refresh();
        Assert.assertEquals((Object)"foo", (Object)((External)this.context.getBean(External.class)).getName());
        Assert.assertEquals((Object)"bar", (Object)((Another)this.context.getBean(Another.class)).getName());
    }

    private Properties getProperties(String values) throws Exception {
        return PropertiesLoaderUtils.loadProperties((Resource)new ByteArrayResource(values.getBytes()));
    }

    @ConfigurationProperties(name="another")
    public static class Another {
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    @ConfigurationProperties(name="external")
    public static class External {
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    @EnableConfigurationProperties(value={External.class, Another.class})
    @Configuration
    public static class FurtherExampleConfig {
    }

    @EnableConfigurationProperties(value={External.class})
    @Configuration
    public static class AnotherExampleConfig {
    }

    @EnableConfigurationProperties
    @Configuration
    public static class ExampleConfig {
        @Bean
        public External external() {
            return new External();
        }
    }
}

