/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Registration;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import org.springframework.boot.context.embedded.RegistrationBean;
import org.springframework.util.Assert;

public class ServletRegistrationBean
extends RegistrationBean {
    private static final String[] DEFAULT_MAPPINGS = new String[]{"/*"};
    private Servlet servlet;
    private Set<String> urlMappings = new LinkedHashSet<String>();
    private int loadOnStartup = 1;
    private MultipartConfigElement multipartConfig;

    public ServletRegistrationBean() {
    }

    public ServletRegistrationBean(Servlet servlet, String ... urlMappings) {
        Assert.notNull((Object)servlet, (String)"Servlet must not be null");
        Assert.notNull((Object)urlMappings, (String)"UrlMappings must not be null");
        this.servlet = servlet;
        this.urlMappings.addAll(Arrays.asList(urlMappings));
    }

    protected Servlet getServlet() {
        return this.servlet;
    }

    public void setServlet(Servlet servlet) {
        Assert.notNull((Object)servlet, (String)"Servlet must not be null");
        this.servlet = servlet;
    }

    public void setUrlMappings(Collection<String> urlMappings) {
        Assert.notNull(urlMappings, (String)"UrlMappings must not be null");
        this.urlMappings = new LinkedHashSet<String>(urlMappings);
    }

    public Collection<String> getUrlMappings() {
        return this.urlMappings;
    }

    public void addUrlMappings(String ... urlMappings) {
        Assert.notNull((Object)urlMappings, (String)"UrlMappings must not be null");
        this.urlMappings.addAll(Arrays.asList(urlMappings));
    }

    public void setLoadOnStartup(int loadOnStartup) {
        this.loadOnStartup = loadOnStartup;
    }

    public void setMultipartConfig(MultipartConfigElement multipartConfig) {
        this.multipartConfig = multipartConfig;
    }

    public MultipartConfigElement getMultipartConfig() {
        return this.multipartConfig;
    }

    public String getServletName() {
        return this.getOrDeduceName(this.servlet);
    }

    @Override
    public void onStartup(ServletContext servletContext) throws ServletException {
        Assert.notNull((Object)this.servlet, (String)"Servlet must not be null");
        this.configure(servletContext.addServlet(this.getServletName(), this.servlet));
    }

    protected void configure(ServletRegistration.Dynamic registration) {
        super.configure((Registration.Dynamic)registration);
        String[] urlMapping = this.urlMappings.toArray(new String[this.urlMappings.size()]);
        if (urlMapping.length == 0) {
            urlMapping = DEFAULT_MAPPINGS;
        }
        registration.addMapping(urlMapping);
        registration.setLoadOnStartup(this.loadOnStartup);
        if (this.multipartConfig != null) {
            registration.setMultipartConfig(this.multipartConfig);
        }
    }
}

