/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded.jetty;

import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.springframework.boot.context.embedded.EmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerException;
import org.springframework.util.Assert;

public class JettyEmbeddedServletContainer
implements EmbeddedServletContainer {
    private final Server server;

    public JettyEmbeddedServletContainer(Server server) {
        Assert.notNull((Object)server, (String)"Jetty Server must not be null");
        this.server = server;
        this.initialize();
    }

    private synchronized void initialize() {
        try {
            Connector[] connectors;
            this.server.start();
            for (Connector connector : connectors = this.server.getConnectors()) {
                connector.stop();
            }
        }
        catch (Exception ex) {
            throw new EmbeddedServletContainerException("Unable to start embedded Jetty servlet container", ex);
        }
    }

    @Override
    public void start() throws EmbeddedServletContainerException {
        try {
            Connector[] connectors;
            this.server.start();
            for (Connector connector : connectors = this.server.getConnectors()) {
                connector.start();
            }
        }
        catch (Exception ex) {
            throw new EmbeddedServletContainerException("Unable to start embedded Jetty servlet container", ex);
        }
    }

    @Override
    public synchronized void stop() {
        try {
            this.server.stop();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (Exception ex) {
            throw new EmbeddedServletContainerException("Unable to stop embedded Jetty servlet container", ex);
        }
    }

    public Server getServer() {
        return this.server;
    }
}

