/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.initializer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class EnvironmentDelegateApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
Ordered {
    private static final String PROPERTY_NAME = "context.initializer.classes";
    private int order = 0;

    public void initialize(ConfigurableApplicationContext applicationContext) {
        ConfigurableEnvironment env = applicationContext.getEnvironment();
        List<Class<ApplicationContextInitializer<ConfigurableApplicationContext>>> initializerClasses = this.determineContextInitializerClasses(env);
        if (initializerClasses.size() == 0) {
            return;
        }
        Class<?> contextClass = applicationContext.getClass();
        ArrayList<Object> initializerInstances = new ArrayList<Object>();
        for (Class<ApplicationContextInitializer<ConfigurableApplicationContext>> clazz : initializerClasses) {
            Class initializerContextClass = GenericTypeResolver.resolveTypeArgument(clazz, ApplicationContextInitializer.class);
            Assert.isAssignable((Class)initializerContextClass, contextClass, (String)String.format("Could not add context initializer [%s] as its generic parameter [%s] is not assignable from the type of application context used by this context loader [%s]: ", clazz.getName(), initializerContextClass.getName(), contextClass.getName()));
            initializerInstances.add(BeanUtils.instantiateClass(clazz));
        }
        Collections.sort(initializerInstances, new AnnotationAwareOrderComparator());
        for (ApplicationContextInitializer applicationContextInitializer : initializerInstances) {
            applicationContextInitializer.initialize(applicationContext);
        }
    }

    private List<Class<ApplicationContextInitializer<ConfigurableApplicationContext>>> determineContextInitializerClasses(ConfigurableEnvironment env) {
        String classNames = env.getProperty(PROPERTY_NAME);
        ArrayList<Class<ApplicationContextInitializer<ConfigurableApplicationContext>>> classes = new ArrayList<Class<ApplicationContextInitializer<ConfigurableApplicationContext>>>();
        if (StringUtils.hasLength((String)classNames)) {
            for (String className : StringUtils.tokenizeToStringArray((String)classNames, (String)",")) {
                try {
                    Class clazz = ClassUtils.forName((String)className, (ClassLoader)ClassUtils.getDefaultClassLoader());
                    Assert.isAssignable(ApplicationContextInitializer.class, (Class)clazz, (String)("class [" + className + "] must implement ApplicationContextInitializer"));
                    classes.add(clazz);
                }
                catch (ClassNotFoundException ex) {
                    throw new ApplicationContextException("Failed to load context initializer class [" + className + "]", (Throwable)ex);
                }
            }
        }
        return classes;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }
}

