/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.bind;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.PropertySourcesPropertyResolver;
import org.springframework.util.PatternMatchUtils;

public class PropertySourcesPropertyValues
implements PropertyValues {
    private Map<String, PropertyValue> propertyValues = new ConcurrentHashMap<String, PropertyValue>();
    private PropertySources propertySources;
    private Collection<String> NON_ENUMERABLES = Arrays.asList("systemEnvironment", "systemProperties");

    public PropertySourcesPropertyValues(PropertySources propertySources) {
        this(propertySources, null);
    }

    public PropertySourcesPropertyValues(PropertySources propertySources, Collection<String> systemPropertyNames) {
        this.propertySources = propertySources;
        PropertySourcesPropertyResolver resolver = new PropertySourcesPropertyResolver(propertySources);
        String[] includes = systemPropertyNames == null ? new String[]{} : systemPropertyNames.toArray(new String[0]);
        for (PropertySource source : propertySources) {
            EnumerablePropertySource enumerable;
            if (!(source instanceof EnumerablePropertySource) || (enumerable = (EnumerablePropertySource)source).getPropertyNames().length <= 0) continue;
            for (String propertyName : enumerable.getPropertyNames()) {
                if (this.NON_ENUMERABLES.contains(source.getName()) && !PatternMatchUtils.simpleMatch((String[])includes, (String)propertyName)) continue;
                Object value = source.getProperty(propertyName);
                try {
                    value = resolver.getProperty(propertyName);
                }
                catch (RuntimeException ex) {
                    // empty catch block
                }
                this.propertyValues.put(propertyName, new PropertyValue(propertyName, value));
            }
        }
    }

    public PropertyValue[] getPropertyValues() {
        Collection<PropertyValue> values = this.propertyValues.values();
        return values.toArray(new PropertyValue[values.size()]);
    }

    public PropertyValue getPropertyValue(String propertyName) {
        PropertyValue propertyValue = this.propertyValues.get(propertyName);
        if (propertyValue != null) {
            return propertyValue;
        }
        for (PropertySource source : this.propertySources) {
            Object value = source.getProperty(propertyName);
            if (value == null) continue;
            propertyValue = new PropertyValue(propertyName, value);
            this.propertyValues.put(propertyName, propertyValue);
            return propertyValue;
        }
        return null;
    }

    public PropertyValues changesSince(PropertyValues old) {
        MutablePropertyValues changes = new MutablePropertyValues();
        for (PropertyValue newValue : this.getPropertyValues()) {
            PropertyValue oldValue = old.getPropertyValue(newValue.getName());
            if (oldValue != null && oldValue.equals((Object)newValue)) continue;
            changes.addPropertyValue(newValue);
        }
        return changes;
    }

    public boolean contains(String propertyName) {
        return this.getPropertyValue(propertyName) != null;
    }

    public boolean isEmpty() {
        return this.propertyValues.isEmpty();
    }
}

