/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.embedded.ConfigurableEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.ErrorPage;
import org.springframework.boot.context.embedded.MimeMappings;
import org.springframework.boot.context.embedded.ServletContextInitializer;
import org.springframework.util.Assert;

public abstract class AbstractEmbeddedServletContainerFactory
implements ConfigurableEmbeddedServletContainerFactory {
    private static final String[] COMMON_DOC_ROOTS = new String[]{"src/main/webapp", "public", "static"};
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String contextPath = "";
    private boolean registerDefaultServlet = true;
    private boolean registerJspServlet = true;
    private String jspServletClassName = "org.apache.jasper.servlet.JspServlet";
    private int port = 8080;
    private List<ServletContextInitializer> initializers = new ArrayList<ServletContextInitializer>();
    private File documentRoot;
    private Set<ErrorPage> errorPages = new LinkedHashSet<ErrorPage>();
    private MimeMappings mimeMappings = new MimeMappings(MimeMappings.DEFAULT);
    private InetAddress address;
    private int sessionTimeout;

    public AbstractEmbeddedServletContainerFactory() {
    }

    public AbstractEmbeddedServletContainerFactory(int port) {
        this.port = port;
    }

    public AbstractEmbeddedServletContainerFactory(String contextPath, int port) {
        this.checkContextPath(contextPath);
        this.contextPath = contextPath;
        this.port = port;
    }

    @Override
    public void setContextPath(String contextPath) {
        this.checkContextPath(contextPath);
        this.contextPath = contextPath;
    }

    private void checkContextPath(String contextPath) {
        Assert.notNull((Object)contextPath, (String)"ContextPath must not be null");
        if (contextPath.length() > 0) {
            if ("/".equals(contextPath)) {
                throw new IllegalArgumentException("Root ContextPath must be specified using an empty string");
            }
            if (!contextPath.startsWith("/") || contextPath.endsWith("/")) {
                throw new IllegalArgumentException("ContextPath must start with '/ and not end with '/'");
            }
        }
    }

    public String getContextPath() {
        return this.contextPath;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    @Override
    public void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    @Override
    public void setSessionTimeout(int sessionTimeout, TimeUnit timeUnit) {
        Assert.notNull((Object)((Object)timeUnit), (String)"TimeUnit must not be null");
        this.sessionTimeout = (int)timeUnit.toSeconds(sessionTimeout);
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    @Override
    public void setInitializers(List<? extends ServletContextInitializer> initializers) {
        Assert.notNull(initializers, (String)"Initializers must not be null");
        this.initializers = new ArrayList<ServletContextInitializer>(initializers);
    }

    @Override
    public void addInitializers(ServletContextInitializer ... initializers) {
        Assert.notNull((Object)initializers, (String)"Initializers must not be null");
        this.initializers.addAll(Arrays.asList(initializers));
    }

    public List<ServletContextInitializer> getInitializers() {
        return this.initializers;
    }

    @Override
    public void setDocumentRoot(File documentRoot) {
        this.documentRoot = documentRoot;
    }

    public File getDocumentRoot() {
        return this.documentRoot;
    }

    @Override
    public void setErrorPages(Set<ErrorPage> errorPages) {
        Assert.notNull(errorPages, (String)"ErrorPages must not be null");
        this.errorPages = new LinkedHashSet<ErrorPage>(errorPages);
    }

    @Override
    public void addErrorPages(ErrorPage ... errorPages) {
        Assert.notNull((Object)errorPages, (String)"ErrorPages must not be null");
        this.errorPages.addAll(Arrays.asList(errorPages));
    }

    public Set<ErrorPage> getErrorPages() {
        return this.errorPages;
    }

    @Override
    public void setMimeMappings(MimeMappings mimeMappings) {
        this.mimeMappings = new MimeMappings(mimeMappings);
    }

    public MimeMappings getMimeMappings() {
        return this.mimeMappings;
    }

    @Override
    public void setRegisterDefaultServlet(boolean registerDefaultServlet) {
        this.registerDefaultServlet = registerDefaultServlet;
    }

    public boolean isRegisterJspServlet() {
        return this.registerJspServlet;
    }

    @Override
    public void setRegisterJspServlet(boolean registerJspServlet) {
        this.registerJspServlet = registerJspServlet;
    }

    public boolean isRegisterDefaultServlet() {
        return this.registerDefaultServlet;
    }

    @Override
    public void setJspServletClassName(String jspServletClassName) {
        this.jspServletClassName = jspServletClassName;
    }

    protected String getJspServletClassName() {
        return this.jspServletClassName;
    }

    protected final ServletContextInitializer[] mergeInitializers(ServletContextInitializer ... initializers) {
        ArrayList<ServletContextInitializer> mergedInitializers = new ArrayList<ServletContextInitializer>();
        mergedInitializers.addAll(Arrays.asList(initializers));
        mergedInitializers.addAll(this.getInitializers());
        return mergedInitializers.toArray(new ServletContextInitializer[mergedInitializers.size()]);
    }

    protected final File getValidDocumentRoot() {
        File file = this.getDocumentRoot();
        file = file != null ? file : this.getWarFileDocumentRoot();
        file = file != null ? file : this.getExplodedWarFileDocumentRoot();
        File file2 = file = file != null ? file : this.getCommonDocumentRoot();
        if (file == null && this.logger.isWarnEnabled()) {
            this.logger.debug((Object)("None of the document roots " + Arrays.asList(COMMON_DOC_ROOTS) + " point to a directory and will be ignored."));
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Document root: " + file));
        }
        return file;
    }

    private File getExplodedWarFileDocumentRoot() {
        File file = this.getCodeSourceArchive();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Code archive: " + file));
        }
        if (file != null && file.exists() && file.getAbsolutePath().contains("/WEB-INF/")) {
            String path = file.getAbsolutePath();
            path = path.substring(0, path.indexOf("/WEB-INF/"));
            return new File(path);
        }
        return null;
    }

    private File getArchiveFileDocumentRoot(String extension) {
        File file = this.getCodeSourceArchive();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Code archive: " + file));
        }
        if (file != null && file.exists() && !file.isDirectory() && file.getName().toLowerCase().endsWith(extension)) {
            return file.getAbsoluteFile();
        }
        return null;
    }

    private File getWarFileDocumentRoot() {
        return this.getArchiveFileDocumentRoot(".war");
    }

    private File getCommonDocumentRoot() {
        for (String commonDocRoot : COMMON_DOC_ROOTS) {
            File root = new File(commonDocRoot);
            if (root == null || !root.exists() || !root.isDirectory()) continue;
            return root.getAbsoluteFile();
        }
        return null;
    }

    private File getCodeSourceArchive() {
        try {
            URL location;
            CodeSource codeSource = this.getClass().getProtectionDomain().getCodeSource();
            URL uRL = location = codeSource == null ? null : codeSource.getLocation();
            if (location == null) {
                return null;
            }
            String path = location.getPath();
            URLConnection connection = location.openConnection();
            if (connection instanceof JarURLConnection) {
                path = ((JarURLConnection)connection).getJarFile().getName();
            }
            if (path.indexOf("!/") != -1) {
                path = path.substring(0, path.indexOf("!/"));
            }
            return new File(path);
        }
        catch (IOException ex) {
            return null;
        }
    }
}

