/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.initializer;

import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationInitializer;
import org.springframework.boot.logging.LogLevel;
import org.springframework.boot.logging.LoggingSystem;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ResourceUtils;

public class LoggingApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
SpringApplicationInitializer,
Ordered {
    private static final Map<String, String> ENVIRONMENT_SYSTEM_PROPERTY_MAPPING = new HashMap<String, String>();
    private static MultiValueMap<LogLevel, String> LOG_LEVEL_LOGGERS;
    private final Log logger = LogFactory.getLog(this.getClass());
    private int order = -2147483637;
    private boolean parseArgs = true;
    private LogLevel springBootLogging = null;

    @Override
    public void initialize(SpringApplication springApplication, String[] args) {
        if (System.getProperty("PID") == null) {
            System.setProperty("PID", this.getPid());
        }
        LoggingSystem loggingSystem = LoggingSystem.get(springApplication.getClass().getClassLoader());
        loggingSystem.beforeInitialize();
    }

    public void initialize(ConfigurableApplicationContext applicationContext) {
        ConfigurableEnvironment environment = applicationContext.getEnvironment();
        if (this.parseArgs && this.springBootLogging == null) {
            if (environment.containsProperty("debug")) {
                this.springBootLogging = LogLevel.DEBUG;
            }
            if (environment.containsProperty("trace")) {
                this.springBootLogging = LogLevel.TRACE;
            }
        }
        for (Map.Entry<String, String> mapping : ENVIRONMENT_SYSTEM_PROPERTY_MAPPING.entrySet()) {
            if (!environment.containsProperty(mapping.getKey())) continue;
            System.setProperty(mapping.getValue(), environment.getProperty(mapping.getKey()));
        }
        LoggingSystem system = LoggingSystem.get(applicationContext.getClassLoader());
        if (environment.containsProperty("logging.config")) {
            String value = environment.getProperty("logging.config");
            try {
                ResourceUtils.getURL((String)value).openStream().close();
                system.initialize(value);
                return;
            }
            catch (Exception ex) {
                this.logger.warn((Object)("Logging environment value '" + value + "' cannot be opened and will be ignored"));
            }
        }
        system.initialize();
        if (this.springBootLogging != null) {
            this.initializeLogLevel(system, this.springBootLogging);
        }
    }

    protected void initializeLogLevel(LoggingSystem system, LogLevel level) {
        List loggers = (List)LOG_LEVEL_LOGGERS.get((Object)level);
        if (loggers != null) {
            for (String logger : loggers) {
                system.setLogLevel(logger, level);
            }
        }
    }

    private String getPid() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        if (name != null) {
            return name.split("@")[0];
        }
        return "????";
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setSpringBootLogging(LogLevel springBootLogging) {
        this.springBootLogging = springBootLogging;
    }

    public void setParseArgs(boolean parseArgs) {
        this.parseArgs = parseArgs;
    }

    static {
        ENVIRONMENT_SYSTEM_PROPERTY_MAPPING.put("logging.file", "LOG_FILE");
        ENVIRONMENT_SYSTEM_PROPERTY_MAPPING.put("logging.path", "LOG_PATH");
        ENVIRONMENT_SYSTEM_PROPERTY_MAPPING.put("PID", "PID");
        LOG_LEVEL_LOGGERS = new LinkedMultiValueMap();
        LOG_LEVEL_LOGGERS.add((Object)LogLevel.DEBUG, (Object)"org.springframework.boot");
        LOG_LEVEL_LOGGERS.add((Object)LogLevel.TRACE, (Object)"org.springframework");
        LOG_LEVEL_LOGGERS.add((Object)LogLevel.TRACE, (Object)"org.apache.tomcat");
        LOG_LEVEL_LOGGERS.add((Object)LogLevel.TRACE, (Object)"org.eclipse.jetty");
        LOG_LEVEL_LOGGERS.add((Object)LogLevel.TRACE, (Object)"org.hibernate.tool.hbm2ddl");
    }
}

