/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging;

import org.springframework.boot.logging.LoggingSystem;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.ClassUtils;

public abstract class AbstractLoggingSystem
extends LoggingSystem {
    private final ClassLoader classLoader;
    private final String[] paths;

    public AbstractLoggingSystem(ClassLoader classLoader, String ... paths) {
        this.classLoader = classLoader;
        this.paths = (String[])paths.clone();
    }

    protected final ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public void beforeInitialize() {
        this.initializeWithSensibleDefaults();
    }

    @Override
    public void initialize() {
        for (String path : this.paths) {
            ClassPathResource resource = new ClassPathResource(path, this.classLoader);
            if (!resource.exists()) continue;
            this.initialize("classpath:" + path);
            return;
        }
    }

    protected void initializeWithSensibleDefaults() {
        this.initialize(this.getPackagedConfigFile(this.paths[this.paths.length - 1]));
    }

    protected final String getPackagedConfigFile(String fileName) {
        String defaultPath = ClassUtils.getPackageName(this.getClass());
        defaultPath = defaultPath.replace(".", "/");
        defaultPath = defaultPath + "/" + fileName;
        defaultPath = "classpath:" + defaultPath;
        return defaultPath;
    }
}

