/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import java.util.Random;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;
import org.springframework.util.DigestUtils;

public class RandomValuePropertySource
extends PropertySource<Random> {
    public RandomValuePropertySource(String name) {
        super(name, (Object)new Random());
    }

    public Object getProperty(String name) {
        if (!name.startsWith("random.")) {
            return null;
        }
        if (name.endsWith("int")) {
            return ((Random)this.getSource()).nextInt();
        }
        if (name.endsWith("long")) {
            return ((Random)this.getSource()).nextLong();
        }
        byte[] bytes = new byte[32];
        ((Random)this.getSource()).nextBytes(bytes);
        return DigestUtils.md5DigestAsHex((byte[])bytes);
    }

    public static void addToEnvironment(ConfigurableEnvironment environment) {
        environment.getPropertySources().addAfter("systemEnvironment", (PropertySource)new RandomValuePropertySource("random"));
    }
}

