/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.bind;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.PropertySourcesPropertyResolver;
import org.springframework.util.PatternMatchUtils;

public class PropertySourcesPropertyValues
implements PropertyValues {
    private final Map<String, PropertyValue> propertyValues = new ConcurrentHashMap<String, PropertyValue>();
    private final PropertySources propertySources;
    private final Collection<String> NON_ENUMERABLE_ENUMERABLES = Arrays.asList("systemEnvironment", "systemProperties");

    public PropertySourcesPropertyValues(PropertySources propertySources) {
        this(propertySources, null, null);
    }

    public PropertySourcesPropertyValues(PropertySources propertySources, Collection<String> patterns, Collection<String> names) {
        this.propertySources = propertySources;
        PropertySourcesPropertyResolver resolver = new PropertySourcesPropertyResolver(propertySources);
        String[] includes = patterns == null ? new String[]{} : patterns.toArray(new String[0]);
        String[] exacts = names == null ? new String[]{} : names.toArray(new String[0]);
        for (PropertySource source : propertySources) {
            if (source instanceof EnumerablePropertySource) {
                EnumerablePropertySource enumerable = (EnumerablePropertySource)source;
                if (enumerable.getPropertyNames().length <= 0) continue;
                for (String propertyName : enumerable.getPropertyNames()) {
                    if (this.NON_ENUMERABLE_ENUMERABLES.contains(source.getName()) && !PatternMatchUtils.simpleMatch((String[])includes, (String)propertyName)) continue;
                    Object value = source.getProperty(propertyName);
                    try {
                        value = resolver.getProperty(propertyName);
                    }
                    catch (RuntimeException ex) {
                        // empty catch block
                    }
                    this.propertyValues.put(propertyName, new PropertyValue(propertyName, value));
                }
                continue;
            }
            for (String propertyName : exacts) {
                Object value = source.getProperty(propertyName);
                if (value != null) {
                    this.propertyValues.put(propertyName, new PropertyValue(propertyName, value));
                    continue;
                }
                value = source.getProperty(propertyName.toUpperCase());
                if (value == null) continue;
                this.propertyValues.put(propertyName, new PropertyValue(propertyName, value));
            }
        }
    }

    public PropertyValue[] getPropertyValues() {
        Collection<PropertyValue> values = this.propertyValues.values();
        return values.toArray(new PropertyValue[values.size()]);
    }

    public PropertyValue getPropertyValue(String propertyName) {
        PropertyValue propertyValue = this.propertyValues.get(propertyName);
        if (propertyValue != null) {
            return propertyValue;
        }
        for (PropertySource source : this.propertySources) {
            Object value = source.getProperty(propertyName);
            if (value == null) continue;
            propertyValue = new PropertyValue(propertyName, value);
            this.propertyValues.put(propertyName, propertyValue);
            return propertyValue;
        }
        return null;
    }

    public PropertyValues changesSince(PropertyValues old) {
        MutablePropertyValues changes = new MutablePropertyValues();
        for (PropertyValue newValue : this.getPropertyValues()) {
            PropertyValue oldValue = old.getPropertyValue(newValue.getName());
            if (oldValue != null && oldValue.equals((Object)newValue)) continue;
            changes.addPropertyValue(newValue);
        }
        return changes;
    }

    public boolean contains(String propertyName) {
        return this.getPropertyValue(propertyName) != null;
    }

    public boolean isEmpty() {
        return this.propertyValues.isEmpty();
    }
}

