/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import java.util.Random;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;
import org.springframework.util.DigestUtils;
import org.springframework.util.StringUtils;

public class RandomValuePropertySource
extends PropertySource<Random> {
    public RandomValuePropertySource(String name) {
        super(name, (Object)new Random());
    }

    public Object getProperty(String name) {
        if (!name.startsWith("random.")) {
            return null;
        }
        if (name.endsWith("int")) {
            return ((Random)this.getSource()).nextInt();
        }
        if (name.startsWith("random.long")) {
            return ((Random)this.getSource()).nextLong();
        }
        if (name.startsWith("random.int") && name.length() > "random.int".length() + 1) {
            String range = name.substring("random.int".length() + 1);
            range = range.substring(0, range.length() - 1);
            return this.getNextInRange(range);
        }
        byte[] bytes = new byte[32];
        ((Random)this.getSource()).nextBytes(bytes);
        return DigestUtils.md5DigestAsHex((byte[])bytes);
    }

    private int getNextInRange(String range) {
        String[] tokens = StringUtils.commaDelimitedListToStringArray((String)range);
        Integer start = Integer.valueOf(tokens[0]);
        if (tokens.length == 1) {
            return ((Random)this.getSource()).nextInt(start);
        }
        return start + ((Random)this.getSource()).nextInt(Integer.valueOf(tokens[1]) - start);
    }

    public static void addToEnvironment(ConfigurableEnvironment environment) {
        environment.getPropertySources().addAfter("systemEnvironment", (PropertySource)new RandomValuePropertySource("random"));
    }
}

