/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded.jetty;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.springframework.boot.context.embedded.EmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerException;
import org.springframework.boot.context.embedded.jetty.JettyEmbeddedWebAppContext;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class JettyEmbeddedServletContainer
implements EmbeddedServletContainer {
    private final Log logger = LogFactory.getLog(JettyEmbeddedServletContainer.class);
    private final Server server;
    private final boolean autoStart;
    private Connector[] connectors;

    public JettyEmbeddedServletContainer(Server server) {
        this(server, true);
    }

    public JettyEmbeddedServletContainer(Server server, boolean autoStart) {
        this.autoStart = autoStart;
        Assert.notNull((Object)server, (String)"Jetty Server must not be null");
        this.server = server;
        this.initialize();
    }

    private synchronized void initialize() {
        try {
            this.connectors = this.server.getConnectors();
            this.server.setConnectors(null);
            this.server.start();
        }
        catch (Exception ex) {
            this.stopSilently();
            throw new EmbeddedServletContainerException("Unable to start embedded Jetty servlet container", ex);
        }
    }

    private void stopSilently() {
        try {
            this.server.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void start() throws EmbeddedServletContainerException {
        this.server.setConnectors(this.connectors);
        if (!this.autoStart) {
            return;
        }
        try {
            Connector[] connectors;
            this.server.start();
            for (Handler handler : this.server.getHandlers()) {
                this.handleDeferredInitialize(handler);
            }
            for (Connector connector : connectors = this.server.getConnectors()) {
                connector.start();
                this.logger.info((Object)("Jetty started on port: " + this.getLocalPort(connector)));
            }
        }
        catch (Exception ex) {
            throw new EmbeddedServletContainerException("Unable to start embedded Jetty servlet container", ex);
        }
    }

    private void handleDeferredInitialize(Handler handler) throws Exception {
        if (handler instanceof JettyEmbeddedWebAppContext) {
            ((JettyEmbeddedWebAppContext)handler).deferredInitialize();
        } else if (handler instanceof HandlerWrapper) {
            this.handleDeferredInitialize(((HandlerWrapper)handler).getHandler());
        }
    }

    private Integer getLocalPort(Connector connector) {
        try {
            return (Integer)ReflectionUtils.invokeMethod((Method)ReflectionUtils.findMethod(connector.getClass(), (String)"getLocalPort"), (Object)connector);
        }
        catch (Exception ex) {
            this.logger.info((Object)("could not determine port ( " + ex.getMessage() + ")"));
            return 0;
        }
    }

    @Override
    public synchronized void stop() {
        try {
            this.server.stop();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (Exception ex) {
            throw new EmbeddedServletContainerException("Unable to stop embedded Jetty servlet container", ex);
        }
    }

    @Override
    public int getPort() {
        int i$ = 0;
        Connector[] connectors = this.server.getConnectors();
        Connector[] arr$ = connectors;
        int len$ = arr$.length;
        if (i$ < len$) {
            Connector connector = arr$[i$];
            return this.getLocalPort(connector);
        }
        return 0;
    }

    public Server getServer() {
        return this.server;
    }
}

