/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggerContextVO;
import ch.qos.logback.core.AppenderBase;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Marker;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class LevelRemappingAppender
extends AppenderBase<ILoggingEvent> {
    private static final Map<Level, Level> DEFAULT_REMAPS = Collections.singletonMap(Level.INFO, Level.DEBUG);
    private String destinationLogger = "ROOT";
    private Map<Level, Level> remapLevels = DEFAULT_REMAPS;

    protected void append(ILoggingEvent event) {
        AppendableLogger logger = this.getLogger(this.destinationLogger);
        Level remapped = this.remapLevels.get(event.getLevel());
        logger.callAppenders((ILoggingEvent)(remapped == null ? event : new RemappedLoggingEvent(event)));
    }

    protected AppendableLogger getLogger(String name) {
        LoggerContext loggerContext = (LoggerContext)this.context;
        return new AppendableLogger(loggerContext.getLogger(name));
    }

    public void setDestinationLogger(String destinationLogger) {
        Assert.hasLength((String)destinationLogger, (String)"DestinationLogger must not be empty");
        this.destinationLogger = destinationLogger;
    }

    public void setRemapLevels(String remapLevels) {
        Assert.hasLength((String)remapLevels, (String)"RemapLevels must not be empty");
        this.remapLevels = new HashMap<Level, Level>();
        for (String remap : StringUtils.commaDelimitedListToStringArray((String)remapLevels)) {
            String[] split = StringUtils.split((String)remap, (String)"->");
            Assert.notNull((Object)split, (String)("Remap element '" + remap + "' must contain '->'"));
            this.remapLevels.put(Level.toLevel((String)split[0]), Level.toLevel((String)split[1]));
        }
    }

    private class RemappedLoggingEvent
    implements ILoggingEvent {
        private final ILoggingEvent event;

        public RemappedLoggingEvent(ILoggingEvent event) {
            this.event = event;
        }

        public String getThreadName() {
            return this.event.getThreadName();
        }

        public Level getLevel() {
            Level remappedLevel = (Level)LevelRemappingAppender.this.remapLevels.get(this.event.getLevel());
            return remappedLevel == null ? this.event.getLevel() : remappedLevel;
        }

        public String getMessage() {
            return this.event.getMessage();
        }

        public Object[] getArgumentArray() {
            return this.event.getArgumentArray();
        }

        public String getFormattedMessage() {
            return this.event.getFormattedMessage();
        }

        public String getLoggerName() {
            return this.event.getLoggerName();
        }

        public LoggerContextVO getLoggerContextVO() {
            return this.event.getLoggerContextVO();
        }

        public IThrowableProxy getThrowableProxy() {
            return this.event.getThrowableProxy();
        }

        public StackTraceElement[] getCallerData() {
            return this.event.getCallerData();
        }

        public boolean hasCallerData() {
            return this.event.hasCallerData();
        }

        public Marker getMarker() {
            return this.event.getMarker();
        }

        public Map<String, String> getMDCPropertyMap() {
            return this.event.getMDCPropertyMap();
        }

        @Deprecated
        public Map<String, String> getMdc() {
            return this.event.getMdc();
        }

        public long getTimeStamp() {
            return this.event.getTimeStamp();
        }

        public void prepareForDeferredProcessing() {
            this.event.prepareForDeferredProcessing();
        }
    }

    protected static class AppendableLogger {
        private Logger logger;

        public AppendableLogger(Logger logger) {
            this.logger = logger;
        }

        public void callAppenders(ILoggingEvent event) {
            if (this.logger.isEnabledFor(event.getLevel())) {
                this.logger.callAppenders(event);
            }
        }
    }
}

