/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class ConfigurationWarningsApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static Log logger = LogFactory.getLog(ConfigurationWarningsApplicationContextInitializer.class);

    public void initialize(ConfigurableApplicationContext context) {
        context.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)new ConfigurationWarningsPostProcessor(this.getChecks()));
    }

    protected Check[] getChecks() {
        return new Check[]{new ComponentScanDefaultPackageCheck()};
    }

    protected static class ComponentScanDefaultPackageCheck
    implements Check {
        protected ComponentScanDefaultPackageCheck() {
        }

        @Override
        public String getWarning(BeanDefinitionRegistry registry) {
            if (this.isComponentScanningDefaultPackage(registry)) {
                return "Your ApplicationContext is unlikely to start due to a @ComponentScan of the default package.";
            }
            return null;
        }

        private boolean isComponentScanningDefaultPackage(BeanDefinitionRegistry registry) {
            String[] names;
            for (String name : names = registry.getBeanDefinitionNames()) {
                AnnotatedBeanDefinition annotatedDefinition;
                BeanDefinition definition = registry.getBeanDefinition(name);
                if (!(definition instanceof AnnotatedBeanDefinition) || !this.isScanningDefaultPackage((annotatedDefinition = (AnnotatedBeanDefinition)definition).getMetadata())) continue;
                return true;
            }
            return false;
        }

        private boolean isScanningDefaultPackage(AnnotationMetadata metadata) {
            AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(ComponentScan.class.getName(), true));
            return attributes != null && this.hasNoScanPackageSpecified(attributes) && this.isInDefaultPackage(metadata.getClassName());
        }

        private boolean hasNoScanPackageSpecified(AnnotationAttributes attributes) {
            return this.isAllEmpty(attributes, "value", "basePackages", "basePackageClasses");
        }

        private boolean isAllEmpty(AnnotationAttributes attributes, String ... names) {
            for (String name : names) {
                if (ObjectUtils.isEmpty((Object[])attributes.getStringArray(name))) continue;
                return false;
            }
            return true;
        }

        protected boolean isInDefaultPackage(String className) {
            String packageName = ClassUtils.getPackageName((String)className);
            return StringUtils.isEmpty((Object)packageName);
        }
    }

    protected static interface Check {
        public String getWarning(BeanDefinitionRegistry var1);
    }

    protected static final class ConfigurationWarningsPostProcessor
    implements PriorityOrdered,
    BeanDefinitionRegistryPostProcessor {
        private Check[] checks;

        public ConfigurationWarningsPostProcessor(Check[] checks) {
            this.checks = checks;
        }

        public int getOrder() {
            return 0x7FFFFFFE;
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        }

        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
            for (Check check : this.checks) {
                String message = check.getWarning(registry);
                if (!StringUtils.hasLength((String)message)) continue;
                this.warn(message);
            }
        }

        private void warn(String message) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("\n\n** WARNING ** : " + message + "\n\n"));
            }
        }
    }
}

