/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded.undertow;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.Predicates;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.encoding.ContentEncodingProvider;
import io.undertow.server.handlers.encoding.ContentEncodingRepository;
import io.undertow.server.handlers.encoding.EncodingHandler;
import io.undertow.server.handlers.encoding.GzipEncodingProvider;
import io.undertow.servlet.api.DeploymentManager;
import java.lang.reflect.Field;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.embedded.Compression;
import org.springframework.boot.context.embedded.EmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerException;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class UndertowEmbeddedServletContainer
implements EmbeddedServletContainer {
    private static final Log logger = LogFactory.getLog(UndertowEmbeddedServletContainer.class);
    private final Undertow.Builder builder;
    private final DeploymentManager manager;
    private final String contextPath;
    private final boolean autoStart;
    private final Compression compression;
    private Undertow undertow;
    private boolean started = false;

    public UndertowEmbeddedServletContainer(Undertow.Builder builder, DeploymentManager manager, String contextPath, int port, boolean autoStart, Compression compression) {
        this.builder = builder;
        this.manager = manager;
        this.contextPath = contextPath;
        this.autoStart = autoStart;
        this.compression = compression;
    }

    @Override
    public synchronized void start() throws EmbeddedServletContainerException {
        if (!this.autoStart) {
            return;
        }
        if (this.undertow == null) {
            this.undertow = this.createUndertowServer();
        }
        this.undertow.start();
        this.started = true;
        logger.info((Object)("Undertow started on port(s) " + this.getPortsDescription()));
    }

    private Undertow createUndertowServer() {
        try {
            HttpHandler servletHandler = this.manager.start();
            this.builder.setHandler(this.getContextHandler(servletHandler));
            return this.builder.build();
        }
        catch (ServletException ex) {
            throw new EmbeddedServletContainerException("Unable to start embdedded Undertow", ex);
        }
    }

    private HttpHandler getContextHandler(HttpHandler servletHandler) {
        HttpHandler contextHandler = this.configurationCompressionIfNecessary(servletHandler);
        if (StringUtils.isEmpty((Object)this.contextPath)) {
            return contextHandler;
        }
        return Handlers.path().addPrefixPath(this.contextPath, contextHandler);
    }

    private HttpHandler configurationCompressionIfNecessary(HttpHandler servletHandler) {
        if (this.compression == null || !this.compression.getEnabled()) {
            return servletHandler;
        }
        ContentEncodingRepository encodingRepository = new ContentEncodingRepository();
        Predicate mimeAndSizePredicate = Predicates.and((Predicate[])new Predicate[]{Predicates.maxContentSize((long)this.compression.getMinResponseSize()), Predicates.or((Predicate[])new Predicate[]{new CompressibleMimeTypePredicate(this.compression.getMimeTypes())})});
        encodingRepository.addEncodingHandler("gzip", (ContentEncodingProvider)new GzipEncodingProvider(), 50, mimeAndSizePredicate);
        return new EncodingHandler(encodingRepository).setNext(servletHandler);
    }

    private String getPortsDescription() {
        List<Port> ports = this.getPorts();
        if (!ports.isEmpty()) {
            return StringUtils.collectionToDelimitedString(ports, (String)" ");
        }
        return "unknown";
    }

    private List<Port> getPorts() {
        ArrayList<Port> ports = new ArrayList<Port>();
        try {
            if (!this.autoStart) {
                ports.add(new Port(-1, "unknown"));
            } else {
                Field channelsField = ReflectionUtils.findField(Undertow.class, (String)"channels");
                ReflectionUtils.makeAccessible((Field)channelsField);
                List channels = (List)ReflectionUtils.getField((Field)channelsField, (Object)this.undertow);
                for (Object channel : channels) {
                    Port port = this.getPortFromChannel(channel);
                    if (port == null) continue;
                    ports.add(port);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ports;
    }

    private Port getPortFromChannel(Object channel) {
        ServerSocket socket;
        Object tcpServer = channel;
        String protocol = "http";
        Field sslContext = ReflectionUtils.findField(channel.getClass(), (String)"sslContext");
        if (sslContext != null) {
            tcpServer = this.getTcpServer(channel);
            protocol = "https";
        }
        if ((socket = this.getSocket(tcpServer)) != null) {
            return new Port(socket.getLocalPort(), protocol);
        }
        return null;
    }

    private Object getTcpServer(Object channel) {
        Field field = ReflectionUtils.findField(channel.getClass(), (String)"tcpServer");
        ReflectionUtils.makeAccessible((Field)field);
        return ReflectionUtils.getField((Field)field, (Object)channel);
    }

    private ServerSocket getSocket(Object tcpServer) {
        Field socketField = ReflectionUtils.findField(tcpServer.getClass(), (String)"socket");
        if (socketField == null) {
            return null;
        }
        ReflectionUtils.makeAccessible((Field)socketField);
        return (ServerSocket)ReflectionUtils.getField((Field)socketField, (Object)tcpServer);
    }

    @Override
    public synchronized void stop() throws EmbeddedServletContainerException {
        if (this.started) {
            this.started = false;
            this.undertow.stop();
        }
    }

    @Override
    public int getPort() {
        List<Port> ports = this.getPorts();
        if (ports.isEmpty()) {
            return 0;
        }
        return ports.get(0).getNumber();
    }

    private static class CompressibleMimeTypePredicate
    implements Predicate {
        private final List<MimeType> mimeTypes;

        CompressibleMimeTypePredicate(String[] mimeTypes) {
            this.mimeTypes = new ArrayList<MimeType>(mimeTypes.length);
            for (String mimeTypeString : mimeTypes) {
                this.mimeTypes.add(MimeTypeUtils.parseMimeType((String)mimeTypeString));
            }
        }

        public boolean resolve(HttpServerExchange value) {
            String contentType = value.getResponseHeaders().getFirst("Content-Type");
            if (contentType != null) {
                for (MimeType mimeType : this.mimeTypes) {
                    if (!mimeType.isCompatibleWith(MimeTypeUtils.parseMimeType((String)contentType))) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static class Port {
        private final int number;
        private final String protocol;

        private Port(int number, String protocol) {
            this.number = number;
            this.protocol = protocol;
        }

        public int getNumber() {
            return this.number;
        }

        public String toString() {
            return this.number + " (" + this.protocol + ")";
        }
    }
}

