/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded.undertow;

import io.undertow.Undertow;
import io.undertow.UndertowMessages;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.accesslog.AccessLogHandler;
import io.undertow.server.handlers.accesslog.AccessLogReceiver;
import io.undertow.server.handlers.accesslog.DefaultAccessLogReceiver;
import io.undertow.server.handlers.resource.ClassPathResourceManager;
import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceChangeListener;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.server.handlers.resource.URLResource;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.MimeMapping;
import io.undertow.servlet.api.ServletContainerInitializerInfo;
import io.undertow.servlet.api.ServletStackTraces;
import io.undertow.servlet.handlers.DefaultServlet;
import io.undertow.servlet.util.ImmediateInstanceFactory;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.springframework.boot.context.embedded.AbstractEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.EmbeddedServletContainer;
import org.springframework.boot.context.embedded.ErrorPage;
import org.springframework.boot.context.embedded.MimeMappings;
import org.springframework.boot.context.embedded.ServletContextInitializer;
import org.springframework.boot.context.embedded.Ssl;
import org.springframework.boot.context.embedded.undertow.UndertowBuilderCustomizer;
import org.springframework.boot.context.embedded.undertow.UndertowDeploymentInfoCustomizer;
import org.springframework.boot.context.embedded.undertow.UndertowEmbeddedServletContainer;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.ResourceUtils;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.SslClientAuthMode;
import org.xnio.Xnio;
import org.xnio.XnioWorker;

public class UndertowEmbeddedServletContainerFactory
extends AbstractEmbeddedServletContainerFactory
implements ResourceLoaderAware {
    private static final Set<Class<?>> NO_CLASSES = Collections.emptySet();
    private List<UndertowBuilderCustomizer> builderCustomizers = new ArrayList<UndertowBuilderCustomizer>();
    private List<UndertowDeploymentInfoCustomizer> deploymentInfoCustomizers = new ArrayList<UndertowDeploymentInfoCustomizer>();
    private ResourceLoader resourceLoader;
    private Integer bufferSize;
    private Integer buffersPerRegion;
    private Integer ioThreads;
    private Integer workerThreads;
    private Boolean directBuffers;
    private File accessLogDirectory;
    private String accessLogPattern;
    private boolean accessLogEnabled = false;

    public UndertowEmbeddedServletContainerFactory() {
        this.getJspServlet().setRegistered(false);
    }

    public UndertowEmbeddedServletContainerFactory(int port) {
        super(port);
        this.getJspServlet().setRegistered(false);
    }

    public UndertowEmbeddedServletContainerFactory(String contextPath, int port) {
        super(contextPath, port);
        this.getJspServlet().setRegistered(false);
    }

    public void setBuilderCustomizers(Collection<? extends UndertowBuilderCustomizer> customizers) {
        Assert.notNull(customizers, (String)"Customizers must not be null");
        this.builderCustomizers = new ArrayList<UndertowBuilderCustomizer>(customizers);
    }

    public Collection<UndertowBuilderCustomizer> getBuilderCustomizers() {
        return this.builderCustomizers;
    }

    public void addBuilderCustomizers(UndertowBuilderCustomizer ... customizers) {
        Assert.notNull((Object)customizers, (String)"Customizers must not be null");
        this.builderCustomizers.addAll(Arrays.asList(customizers));
    }

    public void setDeploymentInfoCustomizers(Collection<? extends UndertowDeploymentInfoCustomizer> customizers) {
        Assert.notNull(customizers, (String)"Customizers must not be null");
        this.deploymentInfoCustomizers = new ArrayList<UndertowDeploymentInfoCustomizer>(customizers);
    }

    public Collection<UndertowDeploymentInfoCustomizer> getDeploymentInfoCustomizers() {
        return this.deploymentInfoCustomizers;
    }

    public void addDeploymentInfoCustomizers(UndertowDeploymentInfoCustomizer ... customizers) {
        Assert.notNull((Object)customizers, (String)"UndertowDeploymentInfoCustomizers must not be null");
        this.deploymentInfoCustomizers.addAll(Arrays.asList(customizers));
    }

    @Override
    public EmbeddedServletContainer getEmbeddedServletContainer(ServletContextInitializer ... initializers) {
        DeploymentManager manager = this.createDeploymentManager(initializers);
        int port = this.getPort();
        Undertow.Builder builder = this.createBuilder(port);
        return new UndertowEmbeddedServletContainer(builder, manager, this.getContextPath(), port, port >= 0, this.getCompression());
    }

    private Undertow.Builder createBuilder(int port) {
        Undertow.Builder builder = Undertow.builder();
        if (this.bufferSize != null) {
            builder.setBufferSize(this.bufferSize.intValue());
        }
        if (this.buffersPerRegion != null) {
            builder.setBuffersPerRegion(this.buffersPerRegion.intValue());
        }
        if (this.ioThreads != null) {
            builder.setIoThreads(this.ioThreads.intValue());
        }
        if (this.workerThreads != null) {
            builder.setWorkerThreads(this.workerThreads.intValue());
        }
        if (this.directBuffers != null) {
            builder.setDirectBuffers(this.directBuffers.booleanValue());
        }
        if (this.getSsl() != null && this.getSsl().isEnabled()) {
            this.configureSsl(this.getSsl(), port, builder);
        } else {
            builder.addHttpListener(port, this.getListenAddress());
        }
        for (UndertowBuilderCustomizer customizer : this.builderCustomizers) {
            customizer.customize(builder);
        }
        return builder;
    }

    private void configureSsl(Ssl ssl, int port, Undertow.Builder builder) {
        try {
            SSLContext sslContext = SSLContext.getInstance(ssl.getProtocol());
            sslContext.init(this.getKeyManagers(), this.getTrustManagers(), null);
            builder.addHttpsListener(port, this.getListenAddress(), sslContext);
            builder.setSocketOption(Options.SSL_CLIENT_AUTH_MODE, (Object)this.getSslClientAuthMode(ssl));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException(ex);
        }
        catch (KeyManagementException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private String getListenAddress() {
        if (this.getAddress() == null) {
            return "0.0.0.0";
        }
        return this.getAddress().getHostAddress();
    }

    private SslClientAuthMode getSslClientAuthMode(Ssl ssl) {
        if (ssl.getClientAuth() == Ssl.ClientAuth.NEED) {
            return SslClientAuthMode.REQUIRED;
        }
        if (ssl.getClientAuth() == Ssl.ClientAuth.WANT) {
            return SslClientAuthMode.REQUESTED;
        }
        return SslClientAuthMode.NOT_REQUESTED;
    }

    private KeyManager[] getKeyManagers() {
        try {
            Ssl ssl = this.getSsl();
            String keyStoreType = ssl.getKeyStoreType();
            if (keyStoreType == null) {
                keyStoreType = "JKS";
            }
            KeyStore keyStore = KeyStore.getInstance(keyStoreType);
            URL url = ResourceUtils.getURL((String)ssl.getKeyStore());
            keyStore.load(url.openStream(), ssl.getKeyStorePassword().toCharArray());
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            char[] keyPassword = ssl.getKeyPassword() != null ? ssl.getKeyPassword().toCharArray() : ssl.getKeyStorePassword().toCharArray();
            keyManagerFactory.init(keyStore, keyPassword);
            return keyManagerFactory.getKeyManagers();
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private TrustManager[] getTrustManagers() {
        try {
            String trustStore;
            Ssl ssl = this.getSsl();
            String trustStoreType = ssl.getTrustStoreType();
            if (trustStoreType == null) {
                trustStoreType = "JKS";
            }
            if ((trustStore = ssl.getTrustStore()) == null) {
                return null;
            }
            KeyStore trustedKeyStore = KeyStore.getInstance(trustStoreType);
            URL url = ResourceUtils.getURL((String)trustStore);
            trustedKeyStore.load(url.openStream(), ssl.getTrustStorePassword().toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustedKeyStore);
            return trustManagerFactory.getTrustManagers();
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private DeploymentManager createDeploymentManager(ServletContextInitializer ... initializers) {
        DeploymentInfo deployment = Servlets.deployment();
        this.registerServletContainerInitializerToDriveServletContextInitializers(deployment, initializers);
        deployment.setClassLoader(this.getServletClassLoader());
        deployment.setContextPath(this.getContextPath());
        deployment.setDisplayName(this.getDisplayName());
        deployment.setDeploymentName("spring-boot");
        if (this.isRegisterDefaultServlet()) {
            deployment.addServlet(Servlets.servlet((String)"default", DefaultServlet.class));
        }
        this.configureErrorPages(deployment);
        deployment.setServletStackTraces(ServletStackTraces.NONE);
        deployment.setResourceManager(this.getDocumentRootResourceManager());
        this.configureMimeMappings(deployment);
        for (UndertowDeploymentInfoCustomizer customizer : this.deploymentInfoCustomizers) {
            customizer.customize(deployment);
        }
        if (this.isAccessLogEnabled()) {
            this.configureAccessLog(deployment);
        }
        DeploymentManager manager = Servlets.defaultContainer().addDeployment(deployment);
        manager.deploy();
        SessionManager sessionManager = manager.getDeployment().getSessionManager();
        int sessionTimeout = this.getSessionTimeout() > 0 ? this.getSessionTimeout() : -1;
        sessionManager.setDefaultSessionTimeout(sessionTimeout);
        return manager;
    }

    private void configureAccessLog(DeploymentInfo deploymentInfo) {
        deploymentInfo.addInitialHandlerChainWrapper(new HandlerWrapper(){

            public HttpHandler wrap(HttpHandler handler) {
                return UndertowEmbeddedServletContainerFactory.this.createAccessLogHandler(handler);
            }
        });
    }

    private AccessLogHandler createAccessLogHandler(HttpHandler handler) {
        try {
            this.createAccessLogDirectoryIfNecessary();
            DefaultAccessLogReceiver accessLogReceiver = new DefaultAccessLogReceiver((Executor)this.createWorker(), this.accessLogDirectory, "access_log");
            String formatString = this.accessLogPattern != null ? this.accessLogPattern : "common";
            return new AccessLogHandler(handler, (AccessLogReceiver)accessLogReceiver, formatString, Undertow.class.getClassLoader());
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to create AccessLogHandler", ex);
        }
    }

    private void createAccessLogDirectoryIfNecessary() {
        Assert.state((this.accessLogDirectory != null ? 1 : 0) != 0, (String)"Access log directory is not set");
        if (!this.accessLogDirectory.isDirectory() && !this.accessLogDirectory.mkdirs()) {
            throw new IllegalStateException("Failed to create access log directory '" + this.accessLogDirectory + "'");
        }
    }

    private XnioWorker createWorker() throws IOException {
        Xnio xnio = Xnio.getInstance((ClassLoader)Undertow.class.getClassLoader());
        OptionMap.Builder builder = OptionMap.builder();
        return xnio.createWorker(builder.getMap());
    }

    private void registerServletContainerInitializerToDriveServletContextInitializers(DeploymentInfo deployment, ServletContextInitializer ... initializers) {
        ServletContextInitializer[] mergedInitializers = this.mergeInitializers(initializers);
        Initializer initializer = new Initializer(mergedInitializers);
        deployment.addServletContainerInitalizer(new ServletContainerInitializerInfo(Initializer.class, (InstanceFactory)new ImmediateInstanceFactory((Object)initializer), NO_CLASSES));
    }

    private ClassLoader getServletClassLoader() {
        if (this.resourceLoader != null) {
            return this.resourceLoader.getClassLoader();
        }
        return this.getClass().getClassLoader();
    }

    private ResourceManager getDocumentRootResourceManager() {
        File root = this.getValidDocumentRoot();
        if (root != null && root.isDirectory()) {
            return new FileResourceManager(root, 0L);
        }
        if (root != null && root.isFile()) {
            return new JarResourcemanager(root);
        }
        if (this.resourceLoader != null) {
            return new ClassPathResourceManager(this.resourceLoader.getClassLoader(), "");
        }
        return new ClassPathResourceManager(this.getClass().getClassLoader(), "");
    }

    private void configureErrorPages(DeploymentInfo servletBuilder) {
        for (ErrorPage errorPage : this.getErrorPages()) {
            servletBuilder.addErrorPage(this.getUndertowErrorPage(errorPage));
        }
    }

    private io.undertow.servlet.api.ErrorPage getUndertowErrorPage(ErrorPage errorPage) {
        if (errorPage.getStatus() != null) {
            return new io.undertow.servlet.api.ErrorPage(errorPage.getPath(), errorPage.getStatusCode());
        }
        if (errorPage.getException() != null) {
            return new io.undertow.servlet.api.ErrorPage(errorPage.getPath(), errorPage.getException());
        }
        return new io.undertow.servlet.api.ErrorPage(errorPage.getPath());
    }

    private void configureMimeMappings(DeploymentInfo servletBuilder) {
        for (MimeMappings.Mapping mimeMapping : this.getMimeMappings()) {
            servletBuilder.addMimeMapping(new MimeMapping(mimeMapping.getExtension(), mimeMapping.getMimeType()));
        }
    }

    protected UndertowEmbeddedServletContainer getUndertowEmbeddedServletContainer(Undertow.Builder builder, DeploymentManager manager, int port) {
        return new UndertowEmbeddedServletContainer(builder, manager, this.getContextPath(), port, port >= 0, this.getCompression());
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setBufferSize(Integer bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setBuffersPerRegion(Integer buffersPerRegion) {
        this.buffersPerRegion = buffersPerRegion;
    }

    public void setIoThreads(Integer ioThreads) {
        this.ioThreads = ioThreads;
    }

    public void setWorkerThreads(Integer workerThreads) {
        this.workerThreads = workerThreads;
    }

    public void setDirectBuffers(Boolean directBuffers) {
        this.directBuffers = directBuffers;
    }

    public void setAccessLogDirectory(File accessLogDirectory) {
        this.accessLogDirectory = accessLogDirectory;
    }

    public void setAccessLogPattern(String accessLogPattern) {
        this.accessLogPattern = accessLogPattern;
    }

    public void setAccessLogEnabled(boolean accessLogEnabled) {
        this.accessLogEnabled = accessLogEnabled;
    }

    public boolean isAccessLogEnabled() {
        return this.accessLogEnabled;
    }

    private static class Initializer
    implements ServletContainerInitializer {
        private final ServletContextInitializer[] initializers;

        public Initializer(ServletContextInitializer[] initializers) {
            this.initializers = initializers;
        }

        public void onStartup(Set<Class<?>> classes, ServletContext servletContext) throws ServletException {
            for (ServletContextInitializer initializer : this.initializers) {
                initializer.onStartup(servletContext);
            }
        }
    }

    private static class JarResourcemanager
    implements ResourceManager {
        private final String jarPath;

        public JarResourcemanager(File jarFile) {
            this(jarFile.getAbsolutePath());
        }

        public JarResourcemanager(String jarPath) {
            this.jarPath = jarPath;
        }

        public Resource getResource(String path) throws IOException {
            URL url = new URL("jar:file:" + this.jarPath + "!" + path);
            URLResource resource = new URLResource(url, url.openConnection(), path);
            if (resource.getContentLength() < 0L) {
                return null;
            }
            return resource;
        }

        public boolean isResourceChangeListenerSupported() {
            return false;
        }

        public void registerResourceChangeListener(ResourceChangeListener listener) {
            throw UndertowMessages.MESSAGES.resourceChangeListenerNotSupported();
        }

        public void removeResourceChangeListener(ResourceChangeListener listener) {
            throw UndertowMessages.MESSAGES.resourceChangeListenerNotSupported();
        }

        public void close() throws IOException {
        }
    }
}

