/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.java;

import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.springframework.boot.logging.AbstractLoggingSystem;
import org.springframework.boot.logging.LogFile;
import org.springframework.boot.logging.LogLevel;
import org.springframework.boot.logging.LoggingInitializationContext;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

public class JavaLoggingSystem
extends AbstractLoggingSystem {
    private static final Map<LogLevel, Level> LEVELS;

    public JavaLoggingSystem(ClassLoader classLoader) {
        super(classLoader);
    }

    @Override
    protected String[] getStandardConfigLocations() {
        return new String[]{"logging.properties"};
    }

    @Override
    public void beforeInitialize() {
        super.beforeInitialize();
        Logger.getLogger("").setLevel(Level.SEVERE);
    }

    @Override
    protected void loadDefaults(LogFile logFile) {
        if (logFile != null) {
            this.loadConfiguration(this.getPackagedConfigFile("logging-file.properties"), logFile);
        } else {
            this.loadConfiguration(this.getPackagedConfigFile("logging.properties"), logFile);
        }
    }

    @Override
    protected void loadConfiguration(LoggingInitializationContext initializationContext, String location, LogFile logFile) {
        this.loadConfiguration(location, logFile);
    }

    protected void loadConfiguration(String location, LogFile logFile) {
        Assert.notNull((Object)location, (String)"Location must not be null");
        try {
            String configuration = FileCopyUtils.copyToString((Reader)new InputStreamReader(ResourceUtils.getURL((String)location).openStream()));
            if (logFile != null) {
                configuration = configuration.replace("${LOG_FILE}", StringUtils.cleanPath((String)logFile.toString()));
            }
            LogManager.getLogManager().readConfiguration(new ByteArrayInputStream(configuration.getBytes()));
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not initialize Java logging from " + location, ex);
        }
    }

    @Override
    public void setLogLevel(String loggerName, LogLevel level) {
        Assert.notNull((Object)((Object)level), (String)"Level must not be null");
        Logger logger = Logger.getLogger(loggerName == null ? "" : loggerName);
        logger.setLevel(LEVELS.get((Object)level));
    }

    static {
        HashMap<LogLevel, Level> levels = new HashMap<LogLevel, Level>();
        levels.put(LogLevel.TRACE, Level.FINEST);
        levels.put(LogLevel.DEBUG, Level.FINE);
        levels.put(LogLevel.INFO, Level.INFO);
        levels.put(LogLevel.WARN, Level.WARNING);
        levels.put(LogLevel.ERROR, Level.SEVERE);
        levels.put(LogLevel.FATAL, Level.SEVERE);
        levels.put(LogLevel.OFF, Level.OFF);
        LEVELS = Collections.unmodifiableMap(levels);
    }
}

