/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.ansi;

import java.awt.Color;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.springframework.boot.ansi.AnsiColor;
import org.springframework.boot.ansi.AnsiColors;

public class AnsiColorsTests {
    @Test
    public void getClosestWhenExactMatchShouldReturnAnsiColor() throws Exception {
        Assertions.assertThat((Comparable)((Object)this.getClosest(0))).isEqualTo((Object)AnsiColor.BLACK);
        Assertions.assertThat((Comparable)((Object)this.getClosest(0xAA0000))).isEqualTo((Object)AnsiColor.RED);
        Assertions.assertThat((Comparable)((Object)this.getClosest(43520))).isEqualTo((Object)AnsiColor.GREEN);
        Assertions.assertThat((Comparable)((Object)this.getClosest(0xAA5500))).isEqualTo((Object)AnsiColor.YELLOW);
        Assertions.assertThat((Comparable)((Object)this.getClosest(170))).isEqualTo((Object)AnsiColor.BLUE);
        Assertions.assertThat((Comparable)((Object)this.getClosest(0xAA00AA))).isEqualTo((Object)AnsiColor.MAGENTA);
        Assertions.assertThat((Comparable)((Object)this.getClosest(43690))).isEqualTo((Object)AnsiColor.CYAN);
        Assertions.assertThat((Comparable)((Object)this.getClosest(0xAAAAAA))).isEqualTo((Object)AnsiColor.WHITE);
        Assertions.assertThat((Comparable)((Object)this.getClosest(0x555555))).isEqualTo((Object)AnsiColor.BRIGHT_BLACK);
        Assertions.assertThat((Comparable)((Object)this.getClosest(0xFF5555))).isEqualTo((Object)AnsiColor.BRIGHT_RED);
        Assertions.assertThat((Comparable)((Object)this.getClosest(0x55FF00))).isEqualTo((Object)AnsiColor.BRIGHT_GREEN);
        Assertions.assertThat((Comparable)((Object)this.getClosest(0xFFFF55))).isEqualTo((Object)AnsiColor.BRIGHT_YELLOW);
        Assertions.assertThat((Comparable)((Object)this.getClosest(0x5555FF))).isEqualTo((Object)AnsiColor.BRIGHT_BLUE);
        Assertions.assertThat((Comparable)((Object)this.getClosest(0xFF55FF))).isEqualTo((Object)AnsiColor.BRIGHT_MAGENTA);
        Assertions.assertThat((Comparable)((Object)this.getClosest(0x55FFFF))).isEqualTo((Object)AnsiColor.BRIGHT_CYAN);
        Assertions.assertThat((Comparable)((Object)this.getClosest(0xFFFFFF))).isEqualTo((Object)AnsiColor.BRIGHT_WHITE);
    }

    @Test
    public void getClosestWhenCloseShouldReturnAnsiColor() throws Exception {
        Assertions.assertThat((Comparable)((Object)this.getClosest(0x292424))).isEqualTo((Object)AnsiColor.BLACK);
        Assertions.assertThat((Comparable)((Object)this.getClosest(9181465))).isEqualTo((Object)AnsiColor.RED);
        Assertions.assertThat((Comparable)((Object)this.getClosest(762123))).isEqualTo((Object)AnsiColor.GREEN);
        Assertions.assertThat((Comparable)((Object)this.getClosest(11886345))).isEqualTo((Object)AnsiColor.YELLOW);
        Assertions.assertThat((Comparable)((Object)this.getClosest(723873))).isEqualTo((Object)AnsiColor.BLUE);
        Assertions.assertThat((Comparable)((Object)this.getClosest(10687139))).isEqualTo((Object)AnsiColor.MAGENTA);
        Assertions.assertThat((Comparable)((Object)this.getClosest(767413))).isEqualTo((Object)AnsiColor.CYAN);
        Assertions.assertThat((Comparable)((Object)this.getClosest(0xBAB6B6))).isEqualTo((Object)AnsiColor.WHITE);
        Assertions.assertThat((Comparable)((Object)this.getClosest(6380122))).isEqualTo((Object)AnsiColor.BRIGHT_BLACK);
        Assertions.assertThat((Comparable)((Object)this.getClosest(0xF23333))).isEqualTo((Object)AnsiColor.BRIGHT_RED);
        Assertions.assertThat((Comparable)((Object)this.getClosest(5629964))).isEqualTo((Object)AnsiColor.BRIGHT_GREEN);
        Assertions.assertThat((Comparable)((Object)this.getClosest(16119116))).isEqualTo((Object)AnsiColor.BRIGHT_YELLOW);
        Assertions.assertThat((Comparable)((Object)this.getClosest(5658352))).isEqualTo((Object)AnsiColor.BRIGHT_BLUE);
        Assertions.assertThat((Comparable)((Object)this.getClosest(16404730))).isEqualTo((Object)AnsiColor.BRIGHT_MAGENTA);
        Assertions.assertThat((Comparable)((Object)this.getClosest(0x56F5F5))).isEqualTo((Object)AnsiColor.BRIGHT_CYAN);
        Assertions.assertThat((Comparable)((Object)this.getClosest(15594997))).isEqualTo((Object)AnsiColor.BRIGHT_WHITE);
    }

    private AnsiColor getClosest(int rgb) {
        return AnsiColors.getClosest(new Color(rgb));
    }
}

