/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.bind.convert;

import java.beans.PropertyEditor;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.PropertyEditorRegistrySupport;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalConverter;
import org.springframework.core.convert.converter.GenericConverter;

class PropertyEditorConverter
implements GenericConverter,
ConditionalConverter {
    private static final Set<Class<?>> SKIPPED;
    private final PropertyEditorRegistrySupport registry = new SimpleTypeConverter();

    PropertyEditorConverter() {
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return null;
    }

    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        Class type = targetType.getType();
        if (this.isSkipped(type)) {
            return false;
        }
        PropertyEditor editor = this.registry.getDefaultEditor(type);
        editor = editor != null ? editor : BeanUtils.findEditorByConvention((Class)type);
        return editor != null;
    }

    private boolean isSkipped(Class<?> type) {
        return SKIPPED.stream().anyMatch(c -> c.isAssignableFrom(type));
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        return new SimpleTypeConverter().convertIfNecessary(source, targetType.getType());
    }

    static {
        LinkedHashSet<Class> skipped = new LinkedHashSet<Class>();
        skipped.add(Collection.class);
        skipped.add(Map.class);
        SKIPPED = Collections.unmodifiableSet(skipped);
    }
}

