/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.tomcat;

import java.util.Set;
import org.apache.tomcat.JarScanFilter;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.util.scan.StandardJarScanFilter;
import org.apache.tomcat.util.scan.StandardJarScanner;
import org.springframework.boot.web.embedded.tomcat.TomcatEmbeddedContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class SkipPatternJarScanner
extends StandardJarScanner {
    private final JarScanner jarScanner;

    SkipPatternJarScanner(JarScanner jarScanner, Set<String> patterns) {
        Assert.notNull((Object)jarScanner, (String)"JarScanner must not be null");
        Assert.notNull(patterns, (String)"Patterns must not be null");
        this.jarScanner = jarScanner;
        StandardJarScanFilter filter = new StandardJarScanFilter();
        filter.setTldSkip(StringUtils.collectionToCommaDelimitedString(patterns));
        this.jarScanner.setJarScanFilter((JarScanFilter)filter);
    }

    static void apply(TomcatEmbeddedContext context, Set<String> patterns) {
        SkipPatternJarScanner scanner = new SkipPatternJarScanner(context.getJarScanner(), patterns);
        context.setJarScanner((JarScanner)scanner);
    }
}

