/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.undertow;

import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import org.springframework.boot.web.embedded.undertow.UndertowWebServer;
import org.springframework.boot.web.reactive.server.AbstractReactiveWebServerFactory;
import org.springframework.boot.web.server.WebServer;
import org.springframework.http.server.reactive.UndertowHttpHandlerAdapter;

public class UndertowReactiveWebServerFactory
extends AbstractReactiveWebServerFactory {
    private Integer bufferSize;
    private Integer ioThreads;
    private Integer workerThreads;
    private Boolean directBuffers;

    public UndertowReactiveWebServerFactory() {
    }

    public UndertowReactiveWebServerFactory(int port) {
        super(port);
    }

    @Override
    public WebServer getWebServer(org.springframework.http.server.reactive.HttpHandler httpHandler) {
        Undertow.Builder builder = this.createBuilder(this.getPort());
        UndertowHttpHandlerAdapter handler = new UndertowHttpHandlerAdapter(httpHandler);
        builder.setHandler((HttpHandler)handler);
        return new UndertowWebServer(builder, this.getPort() >= 0);
    }

    private Undertow.Builder createBuilder(int port) {
        Undertow.Builder builder = Undertow.builder();
        if (this.bufferSize != null) {
            builder.setBufferSize(this.bufferSize.intValue());
        }
        if (this.ioThreads != null) {
            builder.setIoThreads(this.ioThreads.intValue());
        }
        if (this.workerThreads != null) {
            builder.setWorkerThreads(this.workerThreads.intValue());
        }
        if (this.directBuffers != null) {
            builder.setDirectBuffers(this.directBuffers.booleanValue());
        }
        builder.addHttpListener(port, this.getListenAddress());
        return builder;
    }

    private String getListenAddress() {
        if (this.getAddress() == null) {
            return "0.0.0.0";
        }
        return this.getAddress().getHostAddress();
    }

    public void setBufferSize(Integer bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setIoThreads(Integer ioThreads) {
        this.ioThreads = ioThreads;
    }

    public void setWorkerThreads(Integer workerThreads) {
        this.workerThreads = workerThreads;
    }

    public void setDirectBuffers(Boolean directBuffers) {
        this.directBuffers = directBuffers;
    }
}

