/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.bind;

import java.util.function.Supplier;
import org.springframework.boot.context.properties.bind.AggregateElementBinder;
import org.springframework.boot.context.properties.bind.BindContext;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.core.ResolvableType;

abstract class AggregateBinder<T> {
    private final BindContext context;

    AggregateBinder(BindContext context) {
        this.context = context;
    }

    public final Object bind(ConfigurationPropertyName name, Bindable<?> target, AggregateElementBinder itemBinder) {
        Supplier<?> value = target.getValue();
        Class type = value == null ? target.getType().resolve() : ResolvableType.forClass(AggregateBinder.class, this.getClass()).resolveGeneric(new int[0]);
        Object result = this.bind(name, target, itemBinder, type);
        if (result == null || value == null || value.get() == null) {
            return result;
        }
        return this.merge(value.get(), result);
    }

    protected abstract Object bind(ConfigurationPropertyName var1, Bindable<?> var2, AggregateElementBinder var3, Class<?> var4);

    protected abstract T merge(T var1, T var2);

    protected final BindContext getContext() {
        return this.context;
    }

    protected static class AggregateSupplier<T> {
        private final Supplier<T> supplier;
        private T supplied;

        public AggregateSupplier(Supplier<T> supplier) {
            this.supplier = supplier;
        }

        public T get() {
            if (this.supplied == null) {
                this.supplied = this.supplier.get();
            }
            return this.supplied;
        }

        public boolean wasSupplied() {
            return this.supplied != null;
        }
    }
}

